/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.bluetooth.scanner;

import android.app.PendingIntent;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import com.android.chileaf.bluetooth.scanner.BluetoothLeScannerImplJB;
import com.android.chileaf.bluetooth.scanner.BluetoothLeScannerImplLollipop;
import com.android.chileaf.bluetooth.scanner.BluetoothLeScannerImplMarshmallow;
import com.android.chileaf.bluetooth.scanner.BluetoothLeScannerImplOreo;
import com.android.chileaf.bluetooth.scanner.ScanCallback;
import com.android.chileaf.bluetooth.scanner.ScanFilter;
import com.android.chileaf.bluetooth.scanner.ScanResult;
import com.android.chileaf.bluetooth.scanner.ScanSettings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BluetoothLeScannerCompat {
    public static final String EXTRA_LIST_SCAN_RESULT = "android.bluetooth.le.extra.LIST_SCAN_RESULT";
    public static final String EXTRA_ERROR_CODE = "android.bluetooth.le.extra.ERROR_CODE";
    public static final String EXTRA_CALLBACK_TYPE = "android.bluetooth.le.extra.CALLBACK_TYPE";
    private static BluetoothLeScannerCompat instance;

    @NonNull
    public static synchronized BluetoothLeScannerCompat getScanner() {
        if (instance != null) {
            return instance;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            instance = new BluetoothLeScannerImplOreo();
            return instance;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            instance = new BluetoothLeScannerImplMarshmallow();
            return instance;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            instance = new BluetoothLeScannerImplLollipop();
            return instance;
        }
        instance = new BluetoothLeScannerImplJB();
        return instance;
    }

    BluetoothLeScannerCompat() {
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    public final void startScan(@NonNull ScanCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        Handler handler = new Handler(Looper.getMainLooper());
        this.startScanInternal(Collections.emptyList(), new ScanSettings.Builder().build(), callback, handler);
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    public final void startScan(@Nullable List<ScanFilter> filters, @Nullable ScanSettings settings, @NonNull ScanCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        Handler handler = new Handler(Looper.getMainLooper());
        this.startScanInternal(filters != null ? filters : Collections.emptyList(), settings != null ? settings : new ScanSettings.Builder().build(), callback, handler);
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    public final void startScan(@Nullable List<ScanFilter> filters, @Nullable ScanSettings settings, @NonNull ScanCallback callback, @Nullable Handler handler) {
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        this.startScanInternal(filters != null ? filters : Collections.emptyList(), settings != null ? settings : new ScanSettings.Builder().build(), callback, handler != null ? handler : new Handler(Looper.getMainLooper()));
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    public final void stopScan(@NonNull ScanCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        this.stopScanInternal(callback);
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    abstract void startScanInternal(@NonNull List<ScanFilter> var1, @NonNull ScanSettings var2, @NonNull ScanCallback var3, @NonNull Handler var4);

    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    abstract void stopScanInternal(@NonNull ScanCallback var1);

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    public final void startScan(@Nullable List<ScanFilter> filters, @Nullable ScanSettings settings, @NonNull Context context, @NonNull PendingIntent callbackIntent) {
        if (callbackIntent == null) {
            throw new IllegalArgumentException("callbackIntent is null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        this.startScanInternal(filters != null ? filters : Collections.emptyList(), settings != null ? settings : new ScanSettings.Builder().build(), context, callbackIntent);
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    public final void stopScan(@NonNull Context context, @NonNull PendingIntent callbackIntent) {
        if (callbackIntent == null) {
            throw new IllegalArgumentException("callbackIntent is null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        this.stopScanInternal(context, callbackIntent);
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    abstract void startScanInternal(@NonNull List<ScanFilter> var1, @NonNull ScanSettings var2, @NonNull Context var3, @NonNull PendingIntent var4);

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADMIN", "android.permission.BLUETOOTH"})
    abstract void stopScanInternal(@NonNull Context var1, @NonNull PendingIntent var2);

    public abstract void flushPendingScanResults(@NonNull ScanCallback var1);

    static class ScanCallbackWrapper {
        @NonNull
        private final Object LOCK = new Object();
        private final boolean emulateFiltering;
        private final boolean emulateBatching;
        private final boolean emulateFoundOrLostCallbackType;
        private boolean scanningStopped;
        @NonNull
        final List<ScanFilter> filters;
        @NonNull
        final ScanSettings scanSettings;
        @NonNull
        final ScanCallback scanCallback;
        @NonNull
        final Handler handler;
        @NonNull
        private final List<ScanResult> scanResults = new ArrayList<ScanResult>();
        @NonNull
        private final Set<String> devicesInBatch = new HashSet<String>();
        @NonNull
        private final Map<String, ScanResult> devicesInRange = new HashMap<String, ScanResult>();
        @NonNull
        private final Runnable flushPendingScanResultsTask = new Runnable(){

            @Override
            public void run() {
                if (!scanningStopped) {
                    this.flushPendingScanResults();
                    handler.postDelayed((Runnable)this, scanSettings.getReportDelayMillis());
                }
            }
        };
        @NonNull
        private final Runnable matchLostNotifierTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long now = SystemClock.elapsedRealtimeNanos();
                Object object = LOCK;
                synchronized (object) {
                    Iterator iterator = devicesInRange.values().iterator();
                    while (iterator.hasNext()) {
                        final ScanResult result = (ScanResult)iterator.next();
                        if (result.getTimestampNanos() >= now - scanSettings.getMatchLostDeviceTimeout()) continue;
                        iterator.remove();
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                scanCallback.onScanResult(4, result);
                            }
                        });
                    }
                    if (!devicesInRange.isEmpty()) {
                        handler.postDelayed((Runnable)this, scanSettings.getMatchLostTaskInterval());
                    }
                }
            }
        };

        ScanCallbackWrapper(boolean offloadedBatchingSupported, boolean offloadedFilteringSupported, @NonNull List<ScanFilter> filters, @NonNull ScanSettings settings, @NonNull ScanCallback callback, @NonNull Handler handler) {
            this.filters = Collections.unmodifiableList(filters);
            this.scanSettings = settings;
            this.scanCallback = callback;
            this.handler = handler;
            this.scanningStopped = false;
            boolean callbackTypesSupported = Build.VERSION.SDK_INT >= 23;
            this.emulateFoundOrLostCallbackType = settings.getCallbackType() != 1 && (!callbackTypesSupported || !settings.getUseHardwareCallbackTypesIfSupported());
            this.emulateFiltering = !filters.isEmpty() && (!offloadedFilteringSupported || !settings.getUseHardwareFilteringIfSupported());
            long delay = settings.getReportDelayMillis();
            boolean bl = this.emulateBatching = delay > 0L && (!offloadedBatchingSupported || !settings.getUseHardwareBatchingIfSupported());
            if (this.emulateBatching) {
                handler.postDelayed(this.flushPendingScanResultsTask, delay);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            this.scanningStopped = true;
            this.handler.removeCallbacksAndMessages(null);
            Object object = this.LOCK;
            synchronized (object) {
                this.devicesInRange.clear();
                this.devicesInBatch.clear();
                this.scanResults.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void flushPendingScanResults() {
            if (this.emulateBatching && !this.scanningStopped) {
                Object object = this.LOCK;
                synchronized (object) {
                    this.scanCallback.onBatchScanResults(new ArrayList<ScanResult>(this.scanResults));
                    this.scanResults.clear();
                    this.devicesInBatch.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void handleScanResult(int callbackType, @NonNull ScanResult scanResult) {
            if (this.scanningStopped || !this.filters.isEmpty() && !this.matches(scanResult)) {
                return;
            }
            String deviceAddress = scanResult.getDevice().getAddress();
            if (this.emulateFoundOrLostCallbackType) {
                ScanResult previousResult;
                boolean firstResult;
                Map<String, ScanResult> map = this.devicesInRange;
                synchronized (map) {
                    firstResult = this.devicesInRange.isEmpty();
                    previousResult = this.devicesInRange.put(deviceAddress, scanResult);
                }
                if (previousResult == null && (this.scanSettings.getCallbackType() & 2) > 0) {
                    this.scanCallback.onScanResult(2, scanResult);
                }
                if (firstResult && (this.scanSettings.getCallbackType() & 4) > 0) {
                    this.handler.removeCallbacks(this.matchLostNotifierTask);
                    this.handler.postDelayed(this.matchLostNotifierTask, this.scanSettings.getMatchLostTaskInterval());
                }
            } else {
                if (this.emulateBatching) {
                    Object object = this.LOCK;
                    synchronized (object) {
                        if (!this.devicesInBatch.contains(deviceAddress)) {
                            this.scanResults.add(scanResult);
                            this.devicesInBatch.add(deviceAddress);
                        }
                    }
                    return;
                }
                this.scanCallback.onScanResult(callbackType, scanResult);
            }
        }

        void handleScanResults(@NonNull List<ScanResult> results) {
            if (this.scanningStopped) {
                return;
            }
            List<ScanResult> filteredResults = results;
            if (this.emulateFiltering) {
                filteredResults = new ArrayList<ScanResult>();
                for (ScanResult result : results) {
                    if (!this.matches(result)) continue;
                    filteredResults.add(result);
                }
            }
            this.scanCallback.onBatchScanResults(filteredResults);
        }

        void handleScanError(int errorCode) {
            this.scanCallback.onScanFailed(errorCode);
        }

        private boolean matches(@NonNull ScanResult result) {
            for (ScanFilter filter : this.filters) {
                if (!filter.matches(result)) continue;
                return true;
            }
            return false;
        }
    }
}

