/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.bluetooth.scanner;

import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.RequiresApi;
import com.android.chileaf.bluetooth.scanner.BluetoothLeScannerCompat;
import com.android.chileaf.bluetooth.scanner.BluetoothLeScannerImplOreo;
import com.android.chileaf.bluetooth.scanner.ScanFilter;
import com.android.chileaf.bluetooth.scanner.ScanResult;
import com.android.chileaf.bluetooth.scanner.ScanSettings;
import java.util.ArrayList;

public class PendingIntentReceiver
extends BroadcastReceiver {
    static final String ACTION = "com.android.chileaf.bluetooth.ACTION_FOUND";
    static final String EXTRA_PENDING_INTENT = "com.android.chileaf.bluetooth.EXTRA_PENDING_INTENT";
    static final String EXTRA_FILTERS = "com.android.chileaf.bluetooth.EXTRA_FILTERS";
    static final String EXTRA_SETTINGS = "com.android.chileaf.bluetooth.EXTRA_SETTINGS";
    static final String EXTRA_USE_HARDWARE_BATCHING = "com.android.chileaf.bluetooth.EXTRA_USE_HARDWARE_BATCHING";
    static final String EXTRA_USE_HARDWARE_FILTERING = "com.android.chileaf.bluetooth.EXTRA_USE_HARDWARE_FILTERING";
    static final String EXTRA_USE_HARDWARE_CALLBACK_TYPES = "com.android.chileaf.bluetooth.EXTRA_USE_HARDWARE_CALLBACK_TYPES";
    static final String EXTRA_MATCH_LOST_TIMEOUT = "com.android.chileaf.bluetooth.EXTRA_MATCH_LOST_TIMEOUT";
    static final String EXTRA_MATCH_LOST_INTERVAL = "com.android.chileaf.bluetooth.EXTRA_MATCH_LOST_INTERVAL";
    static final String EXTRA_MATCH_MODE = "com.android.chileaf.bluetooth.EXTRA_MATCH_MODE";
    static final String EXTRA_NUM_OF_MATCHES = "com.android.chileaf.bluetooth.EXTRA_NUM_OF_MATCHES";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=26)
    public void onReceive(Context context, Intent intent) {
        BluetoothLeScannerImplOreo.PendingIntentExecutorWrapper wrapper;
        if (context == null || intent == null) {
            return;
        }
        PendingIntent callbackIntent = (PendingIntent)intent.getParcelableExtra(EXTRA_PENDING_INTENT);
        if (callbackIntent == null) {
            return;
        }
        ArrayList nativeScanFilters = intent.getParcelableArrayListExtra(EXTRA_FILTERS);
        android.bluetooth.le.ScanSettings nativeScanSettings = (android.bluetooth.le.ScanSettings)intent.getParcelableExtra(EXTRA_SETTINGS);
        if (nativeScanFilters == null || nativeScanSettings == null) {
            return;
        }
        boolean useHardwareBatchingIfSupported = intent.getBooleanExtra(EXTRA_USE_HARDWARE_BATCHING, true);
        boolean useHardwareFilteringIfSupported = intent.getBooleanExtra(EXTRA_USE_HARDWARE_FILTERING, true);
        boolean useHardwareCallbackTypesIfSupported = intent.getBooleanExtra(EXTRA_USE_HARDWARE_CALLBACK_TYPES, true);
        long matchLostDeviceTimeout = intent.getLongExtra(EXTRA_MATCH_LOST_TIMEOUT, 10000L);
        long matchLostTaskInterval = intent.getLongExtra(EXTRA_MATCH_LOST_INTERVAL, 10000L);
        int matchMode = intent.getIntExtra(EXTRA_MATCH_MODE, 1);
        int numOfMatches = intent.getIntExtra(EXTRA_NUM_OF_MATCHES, 3);
        BluetoothLeScannerCompat scanner = BluetoothLeScannerCompat.getScanner();
        BluetoothLeScannerImplOreo scannerImpl = (BluetoothLeScannerImplOreo)scanner;
        ArrayList<ScanFilter> filters = scannerImpl.fromNativeScanFilters(nativeScanFilters);
        ScanSettings settings = scannerImpl.fromNativeScanSettings(nativeScanSettings, useHardwareBatchingIfSupported, useHardwareFilteringIfSupported, useHardwareCallbackTypesIfSupported, matchLostDeviceTimeout, matchLostTaskInterval, matchMode, numOfMatches);
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        boolean offloadedBatchingSupported = adapter.isOffloadedScanBatchingSupported();
        boolean offloadedFilteringSupported = adapter.isOffloadedFilteringSupported();
        BluetoothLeScannerCompat bluetoothLeScannerCompat = scanner;
        synchronized (bluetoothLeScannerCompat) {
            try {
                wrapper = scannerImpl.getWrapper(callbackIntent);
            }
            catch (IllegalStateException e) {
                return;
            }
            if (wrapper == null) {
                wrapper = new BluetoothLeScannerImplOreo.PendingIntentExecutorWrapper(offloadedBatchingSupported, offloadedFilteringSupported, filters, settings, callbackIntent);
                scannerImpl.addWrapper(callbackIntent, wrapper);
            }
        }
        wrapper.executor.setTemporaryContext(context);
        ArrayList nativeScanResults = intent.getParcelableArrayListExtra("android.bluetooth.le.extra.LIST_SCAN_RESULT");
        if (nativeScanResults != null) {
            ArrayList<ScanResult> results = scannerImpl.fromNativeScanResults(nativeScanResults);
            if (settings.getReportDelayMillis() > 0L) {
                wrapper.handleScanResults(results);
            } else if (!results.isEmpty()) {
                int callbackType = intent.getIntExtra("android.bluetooth.le.extra.CALLBACK_TYPE", 1);
                wrapper.handleScanResult(callbackType, results.get(0));
            }
        } else {
            int errorCode = intent.getIntExtra("android.bluetooth.le.extra.ERROR_CODE", 0);
            if (errorCode != 0) {
                wrapper.handleScanError(errorCode);
            }
        }
        wrapper.executor.setTemporaryContext(null);
    }
}

