/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.bluetooth.scanner;

import android.os.ParcelUuid;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.UUID;

final class BluetoothUuid {
    private static final ParcelUuid BASE_UUID = ParcelUuid.fromString((String)"00000000-0000-1000-8000-00805F9B34FB");
    static final int UUID_BYTES_16_BIT = 2;
    static final int UUID_BYTES_32_BIT = 4;
    static final int UUID_BYTES_128_BIT = 16;

    BluetoothUuid() {
    }

    static ParcelUuid parseUuidFrom(byte[] uuidBytes) {
        long shortUuid;
        if (uuidBytes == null) {
            throw new IllegalArgumentException("uuidBytes cannot be null");
        }
        int length = uuidBytes.length;
        if (length != 2 && length != 4 && length != 16) {
            throw new IllegalArgumentException("uuidBytes length invalid - " + length);
        }
        if (length == 16) {
            ByteBuffer buf = ByteBuffer.wrap(uuidBytes).order(ByteOrder.LITTLE_ENDIAN);
            long msb = buf.getLong(8);
            long lsb = buf.getLong(0);
            return new ParcelUuid(new UUID(msb, lsb));
        }
        if (length == 2) {
            shortUuid = uuidBytes[0] & 0xFF;
            shortUuid += (long)((uuidBytes[1] & 0xFF) << 8);
        } else {
            shortUuid = uuidBytes[0] & 0xFF;
            shortUuid += (long)((uuidBytes[1] & 0xFF) << 8);
            shortUuid += (long)((uuidBytes[2] & 0xFF) << 16);
            shortUuid += (long)((uuidBytes[3] & 0xFF) << 24);
        }
        long msb = BASE_UUID.getUuid().getMostSignificantBits() + (shortUuid << 32);
        long lsb = BASE_UUID.getUuid().getLeastSignificantBits();
        return new ParcelUuid(new UUID(msb, lsb));
    }
}

