/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.bluetooth.connect;

import android.bluetooth.BluetoothDevice;
import android.os.Handler;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.android.chileaf.bluetooth.connect.Operation;
import com.android.chileaf.bluetooth.connect.Request;
import com.android.chileaf.bluetooth.connect.RequestHandler;
import com.android.chileaf.bluetooth.connect.SimpleValueRequest;
import com.android.chileaf.bluetooth.connect.callback.BeforeCallback;
import com.android.chileaf.bluetooth.connect.callback.FailCallback;
import com.android.chileaf.bluetooth.connect.callback.InvalidRequestCallback;
import com.android.chileaf.bluetooth.connect.callback.RssiCallback;
import com.android.chileaf.bluetooth.connect.callback.SuccessCallback;

public final class ReadRssiRequest
extends SimpleValueRequest<RssiCallback>
implements Operation {
    ReadRssiRequest(@NonNull Request.Type type) {
        super(type);
    }

    @Override
    @NonNull
    ReadRssiRequest setRequestHandler(@NonNull RequestHandler requestHandler) {
        super.setRequestHandler(requestHandler);
        return this;
    }

    @Override
    @NonNull
    public ReadRssiRequest setHandler(@NonNull Handler handler) {
        super.setHandler(handler);
        return this;
    }

    @Override
    @NonNull
    public ReadRssiRequest done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public ReadRssiRequest fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public ReadRssiRequest invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public ReadRssiRequest before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    @NonNull
    public ReadRssiRequest with(@NonNull RssiCallback callback) {
        super.with(callback);
        return this;
    }

    void notifyRssiRead(@NonNull BluetoothDevice device, @IntRange(from=-128L, to=20L) int rssi) {
        this.handler.post(() -> {
            if (this.valueCallback != null) {
                ((RssiCallback)this.valueCallback).onRssiRead(device, rssi);
            }
        });
    }
}

