/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.fitness.common;

import android.bluetooth.BluetoothDevice;
import android.os.Parcel;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.chileaf.bluetooth.connect.callback.profile.ProfileReadResponse;
import com.android.chileaf.bluetooth.connect.data.Data;
import com.android.chileaf.fitness.common.DateTimeCallback;
import java.util.Calendar;

public abstract class DateTimeDataCallback
extends ProfileReadResponse
implements DateTimeCallback {
    public DateTimeDataCallback() {
    }

    protected DateTimeDataCallback(Parcel in) {
        super(in);
    }

    @Override
    public void onDataReceived(@NonNull BluetoothDevice device, @NonNull Data data) {
        super.onDataReceived(device, data);
        Calendar calendar = DateTimeDataCallback.readDateTime(data, 0);
        if (calendar == null) {
            this.onInvalidDataReceived(device, data);
            return;
        }
        this.onDateTimeReceived(device, calendar);
    }

    @Nullable
    public static Calendar readDateTime(@NonNull Data data, int offset) {
        if (data.size() < offset + 7) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        int year = data.getIntValue(18, offset);
        int month = data.getIntValue(17, offset + 2);
        int day = data.getIntValue(17, offset + 3);
        if (year > 0) {
            calendar.set(1, year);
        } else {
            calendar.clear(1);
        }
        if (month > 0) {
            calendar.set(2, month - 1);
        } else {
            calendar.clear(2);
        }
        if (day > 0) {
            calendar.set(5, day);
        } else {
            calendar.clear(5);
        }
        calendar.set(11, data.getIntValue(17, offset + 4));
        calendar.set(12, data.getIntValue(17, offset + 5));
        calendar.set(13, data.getIntValue(17, offset + 6));
        calendar.set(14, 0);
        return calendar;
    }
}

