/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.fitness.callback;

import android.bluetooth.BluetoothDevice;
import android.os.Parcel;
import androidx.annotation.NonNull;
import com.android.chileaf.bluetooth.connect.callback.profile.ProfileReadResponse;
import com.android.chileaf.bluetooth.connect.data.Data;
import com.android.chileaf.bluetooth.connect.utils.ParserUtils;
import com.android.chileaf.fitness.callback.BluetoothStatusCallback;
import com.android.chileaf.fitness.callback.BodySportCallback;
import com.android.chileaf.fitness.callback.HistoryOfHRDataCallback;
import com.android.chileaf.fitness.callback.HistoryOfHRRecordCallback;
import com.android.chileaf.fitness.callback.HistoryOfSportCallback;
import com.android.chileaf.fitness.callback.IntervalStepCallback;
import com.android.chileaf.fitness.callback.SingleTapRecordCallback;
import com.android.chileaf.fitness.callback.UserInfoCallback;
import com.android.chileaf.model.HistoryOfHeartRate;
import com.android.chileaf.model.HistoryOfRecord;
import com.android.chileaf.model.HistoryOfSport;
import com.android.chileaf.model.IntervalStep;
import com.android.chileaf.util.DateUtil;
import com.android.chileaf.util.HexUtil;
import com.android.chileaf.util.LogUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ReceivedDataCallback
extends ProfileReadResponse
implements UserInfoCallback,
BodySportCallback,
BluetoothStatusCallback,
HistoryOfSportCallback,
HistoryOfHRRecordCallback,
HistoryOfHRDataCallback,
IntervalStepCallback,
SingleTapRecordCallback {
    private static final long END_TAG = 0xFFFFFFFFL;
    private long mStamp = 0L;
    private boolean isCL833 = false;
    private boolean isStamp = false;
    private List<Data> mPackages = new ArrayList<Data>();
    private List<HistoryOfSport> mHistoryOfSports;
    private List<HistoryOfRecord> mHistoryOfRecords;
    private List<HistoryOfHeartRate> mHistoryOfHeartRates;
    private List<IntervalStep> mIntervalSteps;
    private List<HistoryOfRecord> mSingleTapRecords;
    public static final int TYPE_SPORT = 2;
    public static final int TYPE_HEART = 4;
    public static final int TYPE_HEARTS = 6;
    public static final int TYPE_INTERVAL = 8;
    public static final int TYPE_SINGLE_TAP = 16;

    public ReceivedDataCallback() {
    }

    protected ReceivedDataCallback(Parcel in) {
        super(in);
    }

    @Override
    public void onDataReceived(@NonNull BluetoothDevice device, @NonNull Data data) {
        boolean validate;
        super.onDataReceived(device, data);
        boolean bl = validate = data.getIntValue(17, 1).intValue() == data.size();
        if (!validate) {
            this.onInvalidDataReceived(device, data);
            LogUtil.w("onDataReceived:length:%s", data.size());
            return;
        }
        byte[] value = data.getValue();
        int mode = data.getIntValue(17, 2);
        try {
            if (mode == 3) {
                int age = this.getIntParse(value, 5, 1);
                int sex = this.getIntParse(value, 6, 1);
                int weight = this.getIntParse(value, 7, 1);
                int height = this.getIntParse(value, 8, 1);
                long mobile = this.getLongParse(value, 9, 5);
                this.onUserInfoReceived(device, age, sex, weight, height, mobile);
            } else if (mode == 21) {
                int step = this.getIntParse(value, 3, 3);
                int distance = this.getIntParse(value, 6, 3);
                int calorie = this.getIntParse(value, 9, 3);
                this.onSportReceived(device, step, distance, calorie);
            } else if (mode == 63) {
                int status = this.getIntParse(value, 3, 1);
                this.onBluetoothStatusReceived(device, status == 1);
            } else if (mode == 22) {
                if (this.mHistoryOfSports == null) {
                    this.mHistoryOfSports = new ArrayList<HistoryOfSport>();
                }
                long utcTag = this.getLongParse(value, 3, 4);
                if (this.isCL833) {
                    byte[] slice = this.subSlice(value);
                    this.parseSportHistory(slice);
                    Collections.reverse(this.mHistoryOfSports);
                    this.onHistoryOfSportReceived(device, this.mHistoryOfSports);
                    this.mHistoryOfSports.clear();
                } else if (utcTag != 0xFFFFFFFFL) {
                    this.mPackages.add(data);
                } else {
                    for (int index = 0; index < this.mPackages.size(); ++index) {
                        byte[] slice = this.subSlice(this.mPackages.get(index).getValue());
                        this.parseSportHistory(slice);
                        LogUtil.d("HistoryOfSport index:%d values:%s", index, ParserUtils.parse(slice));
                    }
                    this.onHistoryOfSportReceived(device, this.mHistoryOfSports);
                    this.mHistoryOfSports.clear();
                    this.mPackages.clear();
                }
            } else if (mode == 33) {
                long utcTag;
                if (this.mHistoryOfRecords == null) {
                    this.mHistoryOfRecords = new ArrayList<HistoryOfRecord>();
                }
                if ((utcTag = this.getLongParse(value, 3, 4)) != 0xFFFFFFFFL) {
                    this.mPackages.add(data);
                } else {
                    for (int index = 0; index < this.mPackages.size(); ++index) {
                        byte[] slice = this.subSlice(this.mPackages.get(index).getValue());
                        LogUtil.d("mHistoryOfRecords index:%d values:%s", index, ParserUtils.parse(slice));
                        for (int i = 0; i < slice.length / 4; ++i) {
                            int offset = i * 4;
                            long stamp = this.getLongParse(slice, offset, 4);
                            long record = DateUtil.restoreZoneUTC(stamp);
                            this.mHistoryOfRecords.add(new HistoryOfRecord(stamp, record));
                            LogUtil.d("mHistoryOfRecords index:%d record:%s", i, stamp);
                        }
                    }
                    this.onHistoryOfHRRecordReceived(device, this.mHistoryOfRecords);
                    this.mHistoryOfRecords.clear();
                    this.mPackages.clear();
                }
            } else if (mode == 34 || mode == 35) {
                if (this.mHistoryOfHeartRates == null) {
                    this.mHistoryOfHeartRates = new ArrayList<HistoryOfHeartRate>();
                }
                if (mode == 34) {
                    if (!this.isStamp) {
                        this.mStamp = this.getLongParse(value, 3, 4);
                        this.isStamp = true;
                    }
                    this.mPackages.add(data);
                }
                if (mode == 35) {
                    for (int index = 0; index < this.mPackages.size(); ++index) {
                        byte[] slice = this.subSlice(this.mPackages.get(index).getValue());
                        LogUtil.d("mHistoryOfHeartRates index:%d values:%s", index, ParserUtils.parse(slice));
                        for (int i = 4; i < slice.length; ++i) {
                            int heart = this.getIntParse(slice, i, 1);
                            long stamp = DateUtil.restoreZoneUTC(this.mStamp);
                            HistoryOfHeartRate heartRate = new HistoryOfHeartRate(stamp, heart);
                            this.mHistoryOfHeartRates.add(heartRate);
                            ++this.mStamp;
                        }
                    }
                    this.onHistoryOfHRDataReceived(device, this.mHistoryOfHeartRates);
                    this.mHistoryOfHeartRates.clear();
                    this.mPackages.clear();
                    this.isStamp = false;
                    this.mStamp = 0L;
                }
            } else if (mode == 64 || mode == 65) {
                if (this.mIntervalSteps == null) {
                    this.mIntervalSteps = new ArrayList<IntervalStep>();
                }
                if (mode == 64) {
                    this.mPackages.add(data);
                }
                if (mode == 65) {
                    for (int index = 0; index < this.mPackages.size(); ++index) {
                        byte[] slice = this.subSlice(this.mPackages.get(index).getValue());
                        LogUtil.d("mIntervalSteps index:%d values:%s", index, ParserUtils.parse(slice));
                        for (int i = 0; i < slice.length / 8; ++i) {
                            int offset = i * 8;
                            long stamp = DateUtil.restoreZoneUTC(this.getLongParse(slice, offset, 4));
                            int step = this.getIntParse(slice, offset + 4, 4);
                            IntervalStep intervalStep = new IntervalStep(stamp, step);
                            this.mIntervalSteps.add(intervalStep);
                        }
                    }
                    this.onIntervalStepReceived(device, this.mIntervalSteps);
                    this.mIntervalSteps.clear();
                    this.mPackages.clear();
                }
            } else if (mode == 66 || mode == 67) {
                if (this.mSingleTapRecords == null) {
                    this.mSingleTapRecords = new ArrayList<HistoryOfRecord>();
                }
                if (mode == 66) {
                    this.mPackages.add(data);
                }
                if (mode == 67) {
                    for (int index = 0; index < this.mPackages.size(); ++index) {
                        byte[] slice = this.subSlice(this.mPackages.get(index).getValue());
                        LogUtil.d("mSingleTapRecords index:%d values:%s", index, ParserUtils.parse(slice));
                        for (int i = 0; i < slice.length / 4; ++i) {
                            int offset = i * 4;
                            long stamp = this.getLongParse(slice, offset, 4);
                            long record = DateUtil.restoreZoneUTC(stamp);
                            this.mSingleTapRecords.add(new HistoryOfRecord(stamp, record));
                        }
                    }
                    this.onSingleTapRecordReceived(device, this.mSingleTapRecords);
                    this.mSingleTapRecords.clear();
                    this.mPackages.clear();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setCL833(boolean cl833) {
        this.isCL833 = cl833;
    }

    public void clearType(int type) {
        switch (type) {
            case 2: {
                if (this.mHistoryOfSports == null) break;
                this.mHistoryOfSports.clear();
                break;
            }
            case 4: {
                if (this.mHistoryOfRecords == null) break;
                this.mHistoryOfRecords.clear();
                break;
            }
            case 6: {
                if (this.mHistoryOfHeartRates == null) break;
                this.mHistoryOfHeartRates.clear();
                break;
            }
            case 8: {
                if (this.mIntervalSteps == null) break;
                this.mIntervalSteps.clear();
                break;
            }
            case 16: {
                if (this.mSingleTapRecords == null) break;
                this.mSingleTapRecords.clear();
                break;
            }
        }
        this.mPackages.clear();
    }

    private void parseSportHistory(byte[] value) {
        for (int i = 0; i < value.length / 10; ++i) {
            int offset = i * 10;
            long stamp = this.getLongParse(value, offset, 4);
            long step = this.getLongParse(value, offset + 4, 3);
            long calorie = this.getLongParse(value, offset + 7, 3);
            stamp = DateUtil.restoreZoneUTC(stamp);
            this.mHistoryOfSports.add(new HistoryOfSport(stamp, step, calorie));
        }
    }

    private synchronized byte[] subSlice(byte[] value) {
        return HexUtil.subByte(value, 3, value.length - 1);
    }

    private long getLongParse(byte[] bytes, int pos, int len) {
        long val = 0L;
        len += pos;
        for (int i = pos; i < len; ++i) {
            val <<= 8;
            val |= (long)bytes[i] & 0xFFL;
        }
        return val;
    }

    private int getIntParse(byte[] bytes, int pos, int len) {
        int val = 0;
        len += pos;
        for (int i = pos; i < len; ++i) {
            val <<= 8;
            val |= bytes[i] & 0xFF;
        }
        return val;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataType {
    }
}

