/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.bluetooth.connect;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.os.Handler;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.chileaf.bluetooth.connect.Bytes;
import com.android.chileaf.bluetooth.connect.Operation;
import com.android.chileaf.bluetooth.connect.Request;
import com.android.chileaf.bluetooth.connect.RequestHandler;
import com.android.chileaf.bluetooth.connect.SimpleValueRequest;
import com.android.chileaf.bluetooth.connect.callback.BeforeCallback;
import com.android.chileaf.bluetooth.connect.callback.DataSentCallback;
import com.android.chileaf.bluetooth.connect.callback.FailCallback;
import com.android.chileaf.bluetooth.connect.callback.InvalidRequestCallback;
import com.android.chileaf.bluetooth.connect.callback.SuccessCallback;
import com.android.chileaf.bluetooth.connect.callback.WriteProgressCallback;
import com.android.chileaf.bluetooth.connect.data.Data;
import com.android.chileaf.bluetooth.connect.data.DataSplitter;
import com.android.chileaf.bluetooth.connect.data.DefaultMtuSplitter;
import java.util.Arrays;

public final class WriteRequest
extends SimpleValueRequest<DataSentCallback>
implements Operation {
    private static final DataSplitter MTU_SPLITTER = new DefaultMtuSplitter();
    private WriteProgressCallback progressCallback;
    private DataSplitter dataSplitter;
    private final byte[] data;
    private final int writeType;
    private byte[] currentChunk;
    private byte[] nextChunk;
    private int count = 0;
    private boolean complete = false;

    WriteRequest(@NonNull Request.Type type) {
        this(type, (BluetoothGattCharacteristic)null);
    }

    WriteRequest(@NonNull Request.Type type, @Nullable BluetoothGattCharacteristic characteristic) {
        super(type, characteristic);
        this.data = null;
        this.writeType = 0;
        this.complete = true;
    }

    WriteRequest(@NonNull Request.Type type, @Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] data, @IntRange(from=0L) int offset, @IntRange(from=0L) int length, int writeType) {
        super(type, characteristic);
        this.data = Bytes.copy(data, offset, length);
        this.writeType = writeType;
    }

    WriteRequest(@NonNull Request.Type type, @Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] data, @IntRange(from=0L) int offset, @IntRange(from=0L) int length) {
        super(type, characteristic);
        this.data = Bytes.copy(data, offset, length);
        this.writeType = 0;
    }

    WriteRequest(@NonNull Request.Type type, @Nullable BluetoothGattDescriptor descriptor, @Nullable byte[] data, @IntRange(from=0L) int offset, @IntRange(from=0L) int length) {
        super(type, descriptor);
        this.data = Bytes.copy(data, offset, length);
        this.writeType = 2;
    }

    @Override
    @NonNull
    WriteRequest setRequestHandler(@NonNull RequestHandler requestHandler) {
        super.setRequestHandler(requestHandler);
        return this;
    }

    @Override
    @NonNull
    public WriteRequest setHandler(@NonNull Handler handler) {
        super.setHandler(handler);
        return this;
    }

    @Override
    @NonNull
    public WriteRequest done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public WriteRequest fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public WriteRequest invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public WriteRequest before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    @NonNull
    public WriteRequest with(@NonNull DataSentCallback callback) {
        super.with(callback);
        return this;
    }

    @NonNull
    public WriteRequest split(@NonNull DataSplitter splitter) {
        this.dataSplitter = splitter;
        this.progressCallback = null;
        return this;
    }

    @NonNull
    public WriteRequest split(@NonNull DataSplitter splitter, @NonNull WriteProgressCallback callback) {
        this.dataSplitter = splitter;
        this.progressCallback = callback;
        return this;
    }

    @NonNull
    public WriteRequest split() {
        this.dataSplitter = MTU_SPLITTER;
        this.progressCallback = null;
        return this;
    }

    @NonNull
    public WriteRequest split(@NonNull WriteProgressCallback callback) {
        this.dataSplitter = MTU_SPLITTER;
        this.progressCallback = callback;
        return this;
    }

    void forceSplit() {
        if (this.dataSplitter == null) {
            this.split();
        }
    }

    byte[] getData(@IntRange(from=23L, to=517L) int mtu) {
        if (this.dataSplitter == null || this.data == null) {
            this.complete = true;
            this.currentChunk = this.data;
            return this.data;
        }
        int maxLength = this.writeType != 4 ? mtu - 3 : mtu - 12;
        byte[] chunk = this.nextChunk;
        if (chunk == null) {
            chunk = this.dataSplitter.chunk(this.data, this.count, maxLength);
        }
        if (chunk != null) {
            this.nextChunk = this.dataSplitter.chunk(this.data, this.count + 1, maxLength);
        }
        if (this.nextChunk == null) {
            this.complete = true;
        }
        this.currentChunk = chunk;
        return chunk;
    }

    boolean notifyPacketSent(@NonNull BluetoothDevice device, @Nullable byte[] data) {
        this.handler.post(() -> {
            if (this.progressCallback != null) {
                this.progressCallback.onPacketSent(device, data, this.count);
            }
        });
        ++this.count;
        if (this.complete) {
            this.handler.post(() -> {
                if (this.valueCallback != null) {
                    ((DataSentCallback)this.valueCallback).onDataSent(device, new Data(this.data));
                }
            });
        }
        return Arrays.equals(data, this.currentChunk);
    }

    boolean hasMore() {
        return !this.complete;
    }

    int getWriteType() {
        return this.writeType;
    }
}

