/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.bluetooth.connect;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.os.Handler;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.chileaf.bluetooth.connect.AwaitingRequest;
import com.android.chileaf.bluetooth.connect.Operation;
import com.android.chileaf.bluetooth.connect.Request;
import com.android.chileaf.bluetooth.connect.RequestHandler;
import com.android.chileaf.bluetooth.connect.callback.BeforeCallback;
import com.android.chileaf.bluetooth.connect.callback.DataReceivedCallback;
import com.android.chileaf.bluetooth.connect.callback.FailCallback;
import com.android.chileaf.bluetooth.connect.callback.InvalidRequestCallback;
import com.android.chileaf.bluetooth.connect.callback.ReadProgressCallback;
import com.android.chileaf.bluetooth.connect.callback.SuccessCallback;
import com.android.chileaf.bluetooth.connect.callback.profile.ProfileReadResponse;
import com.android.chileaf.bluetooth.connect.data.Data;
import com.android.chileaf.bluetooth.connect.data.DataFilter;
import com.android.chileaf.bluetooth.connect.data.DataMerger;
import com.android.chileaf.bluetooth.connect.data.DataStream;
import com.android.chileaf.bluetooth.connect.exception.BluetoothDisabledException;
import com.android.chileaf.bluetooth.connect.exception.DeviceDisconnectedException;
import com.android.chileaf.bluetooth.connect.exception.InvalidDataException;
import com.android.chileaf.bluetooth.connect.exception.InvalidRequestException;
import com.android.chileaf.bluetooth.connect.exception.RequestFailedException;

public final class WaitForValueChangedRequest
extends AwaitingRequest<DataReceivedCallback>
implements Operation {
    private ReadProgressCallback progressCallback;
    private DataMerger dataMerger;
    private DataStream buffer;
    private DataFilter filter;
    private boolean deviceDisconnected;
    private boolean bluetoothDisabled;
    private int count = 0;

    WaitForValueChangedRequest(@NonNull Request.Type type, @Nullable BluetoothGattCharacteristic characteristic) {
        super(type, characteristic);
    }

    WaitForValueChangedRequest(@NonNull Request.Type type, @Nullable BluetoothGattDescriptor descriptor) {
        super(type, descriptor);
    }

    @Override
    @NonNull
    WaitForValueChangedRequest setRequestHandler(@NonNull RequestHandler requestHandler) {
        super.setRequestHandler(requestHandler);
        return this;
    }

    @Override
    @NonNull
    public WaitForValueChangedRequest setHandler(@NonNull Handler handler) {
        super.setHandler(handler);
        return this;
    }

    @Override
    @NonNull
    public WaitForValueChangedRequest timeout(@IntRange(from=0L) long timeout) {
        super.timeout(timeout);
        return this;
    }

    @Override
    @NonNull
    public WaitForValueChangedRequest done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public WaitForValueChangedRequest fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public WaitForValueChangedRequest invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public WaitForValueChangedRequest before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    @NonNull
    public WaitForValueChangedRequest with(@NonNull DataReceivedCallback callback) {
        super.with(callback);
        return this;
    }

    @Override
    @NonNull
    public WaitForValueChangedRequest trigger(@NonNull Operation trigger) {
        super.trigger(trigger);
        return this;
    }

    @NonNull
    public WaitForValueChangedRequest filter(@NonNull DataFilter filter) {
        this.filter = filter;
        return this;
    }

    @NonNull
    public WaitForValueChangedRequest merge(@NonNull DataMerger merger) {
        this.dataMerger = merger;
        this.progressCallback = null;
        return this;
    }

    @NonNull
    public WaitForValueChangedRequest merge(@NonNull DataMerger merger, @NonNull ReadProgressCallback callback) {
        this.dataMerger = merger;
        this.progressCallback = callback;
        return this;
    }

    @NonNull
    public <E extends ProfileReadResponse> E awaitValid(@NonNull E response) throws RequestFailedException, InvalidDataException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException, InterruptedException {
        E result = this.await(response);
        if (result != null && !result.isValid()) {
            throw new InvalidDataException(result);
        }
        return result;
    }

    @NonNull
    public <E extends ProfileReadResponse> E awaitValid(@NonNull Class<E> responseClass) throws RequestFailedException, InvalidDataException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException, InterruptedException {
        ProfileReadResponse response = (ProfileReadResponse)((Object)this.await(responseClass));
        if (response != null && !response.isValid()) {
            throw new InvalidDataException(response);
        }
        return (E)response;
    }

    @Deprecated
    @NonNull
    public <E extends ProfileReadResponse> E awaitValid(@NonNull Class<E> responseClass, @IntRange(from=0L) long timeout) throws InterruptedException, InvalidDataException, RequestFailedException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException {
        return this.timeout(timeout).awaitValid(responseClass);
    }

    @Deprecated
    @NonNull
    public <E extends ProfileReadResponse> E awaitValid(@NonNull E response, @IntRange(from=0L) long timeout) throws InterruptedException, InvalidDataException, DeviceDisconnectedException, RequestFailedException, BluetoothDisabledException, InvalidRequestException {
        return this.timeout(timeout).awaitValid(response);
    }

    boolean matches(byte[] packet) {
        return this.filter == null || this.filter.filter(packet);
    }

    void notifyValueChanged(BluetoothDevice device, byte[] value) {
        DataReceivedCallback valueCallback = (DataReceivedCallback)this.valueCallback;
        if (valueCallback == null) {
            return;
        }
        if (this.dataMerger == null) {
            Data data = new Data(value);
            this.handler.post(() -> valueCallback.onDataReceived(device, data));
        } else {
            int c = this.count;
            this.handler.post(() -> {
                if (this.progressCallback != null) {
                    this.progressCallback.onPacketReceived(device, value, c);
                }
            });
            if (this.buffer == null) {
                this.buffer = new DataStream();
            }
            if (this.dataMerger.merge(this.buffer, value, this.count++)) {
                Data data = this.buffer.toData();
                this.handler.post(() -> valueCallback.onDataReceived(device, data));
                this.buffer = null;
                this.count = 0;
            }
        }
    }

    boolean hasMore() {
        return this.count > 0;
    }
}

