/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.fitness.common.parser;

import com.android.chileaf.bluetooth.connect.data.Data;
import com.android.chileaf.fitness.common.parser.DateTimeParser;

public class BloodPressureMeasurementParser {
    public static String parse(Data data) {
        StringBuilder builder = new StringBuilder();
        int offset = 0;
        int flags = data.getIntValue(17, offset++);
        int unitType = flags & 1;
        boolean timestampPresent = (flags & 2) > 0;
        boolean pulseRatePresent = (flags & 4) > 0;
        boolean userIdPresent = (flags & 8) > 0;
        boolean statusPresent = (flags & 0x10) > 0;
        float systolic = data.getFloatValue(50, offset).floatValue();
        float diastolic = data.getFloatValue(50, offset + 2).floatValue();
        float meanArterialPressure = data.getFloatValue(50, offset + 4).floatValue();
        String unit = unitType == 0 ? " mmHg" : " kPa";
        offset += 6;
        builder.append("Systolic: ").append(systolic).append(unit);
        builder.append(" Diastolic: ").append(diastolic).append(unit);
        builder.append(" Mean AP: ").append(meanArterialPressure).append(unit);
        if (timestampPresent) {
            builder.append(" Timestamp: ").append(DateTimeParser.parse(data, offset));
            offset += 7;
        }
        if (pulseRatePresent) {
            float pulseRate = data.getFloatValue(50, offset).floatValue();
            offset += 2;
            builder.append(" Pulse: ").append(pulseRate).append(" bpm");
        }
        if (userIdPresent) {
            int userId = data.getIntValue(17, offset);
            ++offset;
            builder.append(" User ID: ").append(userId);
        }
        if (statusPresent) {
            int status = data.getIntValue(18, offset);
            if ((status & 1) > 0) {
                builder.append(" Body movement detected");
            }
            if ((status & 2) > 0) {
                builder.append(" Cuff too lose");
            }
            if ((status & 4) > 0) {
                builder.append(" Irregular pulse detected");
            }
            if ((status & 0x18) == 8) {
                builder.append(" Pulse rate exceeds upper limit");
            }
            if ((status & 0x18) == 16) {
                builder.append(" Pulse rate is less than lower limit");
            }
            if ((status & 0x18) == 24) {
                builder.append(" Pulse rate range: Reserved for future use ");
            }
            if ((status & 0x20) > 0) {
                builder.append(" Improper measurement position");
            }
        }
        return builder.toString();
    }
}

