/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.ParcelUuid;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.chileaf.bluetooth.connect.BleManager;
import com.android.chileaf.bluetooth.connect.data.Data;
import com.android.chileaf.bluetooth.scanner.BluetoothLeScannerCompat;
import com.android.chileaf.bluetooth.scanner.ScanCallback;
import com.android.chileaf.bluetooth.scanner.ScanFilter;
import com.android.chileaf.bluetooth.scanner.ScanSettings;
import com.android.chileaf.fitness.FitnessManager;
import com.android.chileaf.fitness.callback.BluetoothStatusCallback;
import com.android.chileaf.fitness.callback.BodySportCallback;
import com.android.chileaf.fitness.callback.HistoryOfHRDataCallback;
import com.android.chileaf.fitness.callback.HistoryOfHRRecordCallback;
import com.android.chileaf.fitness.callback.HistoryOfSportCallback;
import com.android.chileaf.fitness.callback.IntervalStepCallback;
import com.android.chileaf.fitness.callback.ReceivedDataCallback;
import com.android.chileaf.fitness.callback.SingleTapRecordCallback;
import com.android.chileaf.fitness.callback.UserInfoCallback;
import com.android.chileaf.fitness.callback.WearManagerCallbacks;
import com.android.chileaf.fitness.common.heart.BodySensorLocationDataCallback;
import com.android.chileaf.fitness.common.heart.HeartRateMeasurementCallback;
import com.android.chileaf.fitness.common.heart.HeartRateMeasurementDataCallback;
import com.android.chileaf.fitness.common.parser.BodySensorLocationParser;
import com.android.chileaf.fitness.common.parser.HeartRateMeasurementParser;
import com.android.chileaf.model.HistoryOfHeartRate;
import com.android.chileaf.model.HistoryOfRecord;
import com.android.chileaf.model.HistoryOfSport;
import com.android.chileaf.model.IntervalStep;
import com.android.chileaf.util.DateUtil;
import com.android.chileaf.util.HexUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class WearManager
extends FitnessManager<WearManagerCallbacks> {
    private static final UUID HR_SERVICE_UUID = UUID.fromString("0000180D-0000-1000-8000-00805f9b34fb");
    private static final UUID BODY_SENSOR_LOCATION_CHARACTERISTIC_UUID = UUID.fromString("00002A38-0000-1000-8000-00805f9b34fb");
    private static final UUID HEART_RATE_MEASUREMENT_CHARACTERISTIC_UUID = UUID.fromString("00002A37-0000-1000-8000-00805f9b34fb");
    private static final String MODE_NAME = "CL831";
    private ScanCallback mScanCallback;
    private static WearManager managerInstance = null;
    private BluetoothGattCharacteristic mBodySensorLocationCharacteristic;
    private BluetoothGattCharacteristic mHeartRateCharacteristic;
    private List<UserInfoCallback> mUserInfoCallbacks;
    private List<BodySportCallback> mBodySportCallbacks;
    private List<HeartRateMeasurementCallback> mHeartRateMeasurementCallbacks;
    private List<HistoryOfSportCallback> mHistoryOfSportCallbacks;
    private List<HistoryOfHRRecordCallback> mHistoryOfHRRecordCallbacks;
    private List<HistoryOfHRDataCallback> mHistoryOfHRDataCallbacks;
    private List<IntervalStepCallback> mIntervalStepsCallbacks;
    private List<SingleTapRecordCallback> mSingleTapRecordCallbacks;
    private BluetoothStatusCallback mBluetoothStatusCallback;
    private final BodySensorLocationDataCallback mBodySensorLocationDataCallback = new BodySensorLocationDataCallback(){

        @Override
        public void onBodySensorLocationReceived(@NonNull BluetoothDevice device, int sensorLocation) {
            ((WearManagerCallbacks)WearManager.this.mCallbacks).onBodySensorLocationReceived(device, sensorLocation);
        }

        @Override
        public void onDataReceived(@NonNull BluetoothDevice device, @NonNull Data data) {
            WearManager.this.log(3, String.format("%s received", BodySensorLocationParser.parse(data)));
            super.onDataReceived(device, data);
        }
    };
    private final HeartRateMeasurementDataCallback mHeartRateMeasureDataCallback = new HeartRateMeasurementDataCallback(){

        @Override
        public void onHeartRateMeasurementReceived(@NonNull BluetoothDevice device, int heartRate, @Nullable Boolean contactDetected, @Nullable Integer energyExpanded, @Nullable List<Integer> rrIntervals) {
            ((WearManagerCallbacks)WearManager.this.mCallbacks).onHeartRateMeasurementReceived(device, heartRate, contactDetected, energyExpanded, rrIntervals);
            if (WearManager.this.mHeartRateMeasurementCallbacks != null && !WearManager.this.mHeartRateMeasurementCallbacks.isEmpty()) {
                for (HeartRateMeasurementCallback callback : WearManager.this.mHeartRateMeasurementCallbacks) {
                    callback.onHeartRateMeasurementReceived(device, heartRate, contactDetected, energyExpanded, rrIntervals);
                }
            }
        }

        @Override
        public void onDataReceived(@NonNull BluetoothDevice device, @NonNull Data data) {
            WearManager.this.log(3, HeartRateMeasurementParser.parse(data) + " received");
            super.onDataReceived(device, data);
        }
    };
    private final ReceivedDataCallback mReceivedDataCallback = new ReceivedDataCallback(){

        @Override
        public void onSportReceived(@NonNull BluetoothDevice device, int step, int distance, int calorie) {
            ((WearManagerCallbacks)WearManager.this.mCallbacks).onSportReceived(device, step, distance, calorie);
            if (WearManager.this.mBodySportCallbacks != null && !WearManager.this.mBodySportCallbacks.isEmpty()) {
                for (BodySportCallback callback : WearManager.this.mBodySportCallbacks) {
                    callback.onSportReceived(device, step, distance, calorie);
                }
            }
        }

        @Override
        public void onBluetoothStatusReceived(@NonNull BluetoothDevice device, boolean enabled) {
            ((WearManagerCallbacks)WearManager.this.mCallbacks).onBluetoothStatusReceived(device, enabled);
            if (WearManager.this.mBluetoothStatusCallback != null) {
                WearManager.this.mBluetoothStatusCallback.onBluetoothStatusReceived(device, enabled);
            }
        }

        @Override
        public void onUserInfoReceived(@NonNull BluetoothDevice device, int age, int sex, int weight, int height, long userId) {
            if (WearManager.this.mUserInfoCallbacks != null && !WearManager.this.mUserInfoCallbacks.isEmpty()) {
                for (UserInfoCallback callback : WearManager.this.mUserInfoCallbacks) {
                    callback.onUserInfoReceived(device, age, sex, weight, height, userId);
                }
            }
        }

        @Override
        public void onHistoryOfSportReceived(@NonNull BluetoothDevice device, List<HistoryOfSport> sports) {
            if (WearManager.this.mHistoryOfSportCallbacks != null && !WearManager.this.mHistoryOfSportCallbacks.isEmpty()) {
                for (HistoryOfSportCallback callback : WearManager.this.mHistoryOfSportCallbacks) {
                    callback.onHistoryOfSportReceived(device, sports);
                }
            }
        }

        @Override
        public void onHistoryOfHRRecordReceived(@NonNull BluetoothDevice device, List<HistoryOfRecord> records) {
            if (WearManager.this.mHistoryOfHRRecordCallbacks != null && !WearManager.this.mHistoryOfHRRecordCallbacks.isEmpty()) {
                for (HistoryOfHRRecordCallback callback : WearManager.this.mHistoryOfHRRecordCallbacks) {
                    callback.onHistoryOfHRRecordReceived(device, records);
                }
            }
        }

        @Override
        public void onHistoryOfHRDataReceived(@NonNull BluetoothDevice device, List<HistoryOfHeartRate> heartRates) {
            if (WearManager.this.mHistoryOfHRDataCallbacks != null && !WearManager.this.mHistoryOfHRDataCallbacks.isEmpty()) {
                for (HistoryOfHRDataCallback callback : WearManager.this.mHistoryOfHRDataCallbacks) {
                    callback.onHistoryOfHRDataReceived(device, heartRates);
                }
            }
        }

        @Override
        public void onIntervalStepReceived(@NonNull BluetoothDevice device, List<IntervalStep> steps) {
            if (WearManager.this.mIntervalStepsCallbacks != null && !WearManager.this.mIntervalStepsCallbacks.isEmpty()) {
                for (IntervalStepCallback callback : WearManager.this.mIntervalStepsCallbacks) {
                    callback.onIntervalStepReceived(device, steps);
                }
            }
        }

        @Override
        public void onSingleTapRecordReceived(@NonNull BluetoothDevice device, List<HistoryOfRecord> records) {
            if (WearManager.this.mSingleTapRecordCallbacks != null && !WearManager.this.mSingleTapRecordCallbacks.isEmpty()) {
                for (SingleTapRecordCallback callback : WearManager.this.mSingleTapRecordCallbacks) {
                    callback.onSingleTapRecordReceived(device, records);
                }
            }
        }
    };

    public static synchronized WearManager getInstance(Context context) {
        if (managerInstance == null) {
            managerInstance = new WearManager(context);
        }
        return managerInstance;
    }

    private WearManager(Context context) {
        super(context);
    }

    @Override
    public void checkModel(String modelName, boolean isCL833) {
        boolean cl833 = modelName.equalsIgnoreCase(MODE_NAME);
        this.mReceivedDataCallback.setCL833(cl833 && isCL833);
        this.log(6, String.format("checkModel modelName:%s isCL833:%s", modelName, isCL833));
    }

    @Override
    @NonNull
    protected BleManager.BleManagerGattCallback getGattCallback() {
        return new WearManagerGattCallback();
    }

    public void addBodySportCallback(BodySportCallback callback) {
        if (this.mBodySportCallbacks == null) {
            this.mBodySportCallbacks = new ArrayList<BodySportCallback>();
        }
        this.mBodySportCallbacks.add(callback);
    }

    public void addHeartRateMeasurementCallback(HeartRateMeasurementCallback callback) {
        if (this.mHeartRateMeasurementCallbacks == null) {
            this.mHeartRateMeasurementCallbacks = new ArrayList<HeartRateMeasurementCallback>();
        }
        this.mHeartRateMeasurementCallbacks.add(callback);
    }

    public void setBluetoothStatusCallback(BluetoothStatusCallback callback) {
        this.mBluetoothStatusCallback = callback;
    }

    public void addUserInfoCallback(UserInfoCallback callback) {
        if (this.mUserInfoCallbacks == null) {
            this.mUserInfoCallbacks = new ArrayList<UserInfoCallback>();
        }
        this.mUserInfoCallbacks.add(callback);
    }

    public void addHistoryOfSportCallback(HistoryOfSportCallback callback) {
        if (this.mHistoryOfSportCallbacks == null) {
            this.mHistoryOfSportCallbacks = new ArrayList<HistoryOfSportCallback>();
        }
        this.mHistoryOfSportCallbacks.add(callback);
    }

    public void addHistoryOfHRRecordCallback(HistoryOfHRRecordCallback callback) {
        if (this.mHistoryOfHRRecordCallbacks == null) {
            this.mHistoryOfHRRecordCallbacks = new ArrayList<HistoryOfHRRecordCallback>();
        }
        this.mHistoryOfHRRecordCallbacks.add(callback);
    }

    public void addHistoryOfHRDataCallback(HistoryOfHRDataCallback callback) {
        if (this.mHistoryOfHRDataCallbacks == null) {
            this.mHistoryOfHRDataCallbacks = new ArrayList<HistoryOfHRDataCallback>();
        }
        this.mHistoryOfHRDataCallbacks.add(callback);
    }

    public void addIntervalStepCallback(IntervalStepCallback callback) {
        if (this.mIntervalStepsCallbacks == null) {
            this.mIntervalStepsCallbacks = new ArrayList<IntervalStepCallback>();
        }
        this.mIntervalStepsCallbacks.add(callback);
    }

    public void addSingleTapRecordCallback(SingleTapRecordCallback callback) {
        if (this.mSingleTapRecordCallbacks == null) {
            this.mSingleTapRecordCallbacks = new ArrayList<SingleTapRecordCallback>();
        }
        this.mSingleTapRecordCallbacks.add(callback);
    }

    public void startScan(ScanCallback scanCallback) {
        this.mScanCallback = scanCallback;
        BluetoothLeScannerCompat scanner = BluetoothLeScannerCompat.getScanner();
        ScanSettings settings = new ScanSettings.Builder().setLegacy(false).setReportDelay(1000L).setUseHardwareBatchingIfSupported(false).setScanMode(2).build();
        ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
        ParcelUuid uuid = new ParcelUuid(HR_SERVICE_UUID);
        filters.add(new ScanFilter.Builder().setServiceUuid(uuid).build());
        scanner.startScan(filters, settings, this.mScanCallback);
    }

    public void stopScan() {
        if (this.mScanCallback != null) {
            BluetoothLeScannerCompat scanner = BluetoothLeScannerCompat.getScanner();
            scanner.stopScan(this.mScanCallback);
        }
    }

    public void connect(BluetoothDevice device, boolean autoConnect) {
        this.connect(device).useAutoConnect(autoConnect).enqueue();
    }

    private void sendCommand(byte cmd, int ... values) {
        byte[] result;
        int unique = 4;
        if (values != null) {
            int len = values.length + 4;
            byte[] header = HexUtil.compose(255, len, cmd);
            byte[] bytes = HexUtil.compose(values);
            result = HexUtil.append(header, bytes);
        } else {
            result = HexUtil.compose(255, 4, cmd);
        }
        byte check = this.checkSum(result);
        byte[] command = HexUtil.append(result, check);
        this.writeTxCharacteristic(command);
    }

    public void setUTCTime() {
        this.setUTCTime(DateUtil.getZoneUTC());
    }

    public void setUTCTime(long stamp) {
        this.sendCommand((byte)8, this.transformUTC(stamp));
    }

    public void Restoration() {
        this.sendCommand((byte)-13, 0);
    }

    public void setBluetoothDisabled() {
        this.sendCommand((byte)63, 2);
    }

    public void getHistoryOfSport() {
        this.mReceivedDataCallback.clearType(2);
        this.sendCommand((byte)22, 0);
    }

    public void getHistoryOfHRRecord() {
        this.mReceivedDataCallback.clearType(4);
        this.sendCommand((byte)33, 0);
    }

    public void getHistoryOfHRData(long stamp) {
        this.mReceivedDataCallback.clearType(6);
        this.sendCommand((byte)34, HexUtil.append(1, this.transformUTC(stamp)));
    }

    public void getIntervalSteps() {
        this.mReceivedDataCallback.clearType(8);
        this.sendCommand((byte)64, 0);
    }

    public void getSingleTapRecords() {
        this.mReceivedDataCallback.clearType(16);
        this.sendCommand((byte)66, 0);
    }

    public void getUserInfo() {
        this.sendCommand((byte)3, 0);
    }

    public void setUserInfo(int age, int sex, int weight, int height, long userId) {
        int[] command = new int[]{(byte)age, (byte)sex, (byte)weight, (byte)height, (byte)(userId >> 32 & 0xFFL), (byte)(userId >> 24 & 0xFFL), (byte)(userId >> 16 & 0xFFL), (byte)(userId >> 8 & 0xFFL), (byte)(userId & 0xFFL)};
        this.sendCommand((byte)4, command);
    }

    private final class WearManagerGattCallback
    extends FitnessManager.FitnessManagerGattCallback {
        private WearManagerGattCallback() {
            super(WearManager.this);
        }

        @Override
        protected void initialize() {
            super.initialize();
            WearManager.this.readCharacteristic(WearManager.this.mBodySensorLocationCharacteristic).with(WearManager.this.mBodySensorLocationDataCallback).fail((device, status) -> WearManager.this.log(5, "Body Sensor Location characteristic not found")).enqueue();
            WearManager.this.setNotificationCallback(WearManager.this.mHeartRateCharacteristic).with(WearManager.this.mHeartRateMeasureDataCallback);
            WearManager.this.enableNotifications(WearManager.this.mHeartRateCharacteristic).enqueue();
            WearManager.this.setNotificationCallback(WearManager.this.mRXCharacteristic).with(WearManager.this.mReceivedDataCallback);
            WearManager.this.enableNotifications(WearManager.this.mRXCharacteristic).done(device -> WearManager.this.log(3, "Rx notifications enabled")).fail((device, status) -> WearManager.this.log(5, "Rx characteristic not found")).enqueue();
        }

        @Override
        public boolean isRequiredServiceSupported(@NonNull BluetoothGatt gatt) {
            super.isRequiredServiceSupported(gatt);
            BluetoothGattService hrService = gatt.getService(HR_SERVICE_UUID);
            if (hrService != null) {
                WearManager.this.mHeartRateCharacteristic = hrService.getCharacteristic(HEART_RATE_MEASUREMENT_CHARACTERISTIC_UUID);
            }
            return WearManager.this.mHeartRateCharacteristic != null;
        }

        @Override
        protected boolean isOptionalServiceSupported(@NonNull BluetoothGatt gatt) {
            super.isOptionalServiceSupported(gatt);
            BluetoothGattService service = gatt.getService(HR_SERVICE_UUID);
            if (service != null) {
                WearManager.this.mBodySensorLocationCharacteristic = service.getCharacteristic(BODY_SENSOR_LOCATION_CHARACTERISTIC_UUID);
            }
            return WearManager.this.mBodySensorLocationCharacteristic != null;
        }

        @Override
        protected void onDeviceReady() {
            super.onDeviceReady();
            WearManager.this.setUTCTime();
        }

        @Override
        protected void onDeviceDisconnected() {
            super.onDeviceDisconnected();
            WearManager.this.mBodySensorLocationCharacteristic = null;
            WearManager.this.mHeartRateCharacteristic = null;
            WearManager.this.mReceivedDataCallback.setCL833(false);
        }
    }
}

