/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.bluetooth.connect;

import android.os.Handler;
import androidx.annotation.NonNull;
import com.android.chileaf.bluetooth.connect.Operation;
import com.android.chileaf.bluetooth.connect.Request;
import com.android.chileaf.bluetooth.connect.RequestHandler;
import com.android.chileaf.bluetooth.connect.RequestQueue;
import com.android.chileaf.bluetooth.connect.WriteRequest;
import com.android.chileaf.bluetooth.connect.callback.BeforeCallback;
import com.android.chileaf.bluetooth.connect.callback.FailCallback;
import com.android.chileaf.bluetooth.connect.callback.InvalidRequestCallback;
import com.android.chileaf.bluetooth.connect.callback.SuccessCallback;

public final class ReliableWriteRequest
extends RequestQueue {
    private boolean initialized;
    private boolean closed;
    private boolean cancelled;

    @Override
    @NonNull
    ReliableWriteRequest setRequestHandler(@NonNull RequestHandler requestHandler) {
        super.setRequestHandler(requestHandler);
        return this;
    }

    @Override
    @NonNull
    public ReliableWriteRequest setHandler(@NonNull Handler handler) {
        super.setHandler(handler);
        return this;
    }

    @Override
    @NonNull
    public ReliableWriteRequest done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public ReliableWriteRequest fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public ReliableWriteRequest invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public ReliableWriteRequest before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    @Override
    @NonNull
    public ReliableWriteRequest add(@NonNull Operation operation) {
        super.add(operation);
        if (operation instanceof WriteRequest) {
            ((WriteRequest)operation).forceSplit();
        }
        return this;
    }

    @Override
    public void cancelQueue() {
        this.cancelled = true;
        super.cancelQueue();
    }

    public void abort() {
        this.cancelQueue();
    }

    @Override
    public int size() {
        int size = super.size();
        if (!this.initialized) {
            ++size;
        }
        if (!this.closed) {
            ++size;
        }
        return size;
    }

    @Override
    Request getNext() {
        if (!this.initialized) {
            this.initialized = true;
            return ReliableWriteRequest.newBeginReliableWriteRequest();
        }
        if (super.isEmpty()) {
            this.closed = true;
            if (this.cancelled) {
                return ReliableWriteRequest.newAbortReliableWriteRequest();
            }
            return ReliableWriteRequest.newExecuteReliableWriteRequest();
        }
        return super.getNext();
    }

    @Override
    boolean hasMore() {
        if (!this.initialized) {
            return super.hasMore();
        }
        return !this.closed;
    }
}

