/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.bluetooth.connect;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.chileaf.bluetooth.connect.Operation;
import com.android.chileaf.bluetooth.connect.Request;
import com.android.chileaf.bluetooth.connect.RequestHandler;
import com.android.chileaf.bluetooth.connect.SimpleValueRequest;
import com.android.chileaf.bluetooth.connect.callback.BeforeCallback;
import com.android.chileaf.bluetooth.connect.callback.DataReceivedCallback;
import com.android.chileaf.bluetooth.connect.callback.FailCallback;
import com.android.chileaf.bluetooth.connect.callback.InvalidRequestCallback;
import com.android.chileaf.bluetooth.connect.callback.ReadProgressCallback;
import com.android.chileaf.bluetooth.connect.callback.SuccessCallback;
import com.android.chileaf.bluetooth.connect.callback.profile.ProfileReadResponse;
import com.android.chileaf.bluetooth.connect.data.Data;
import com.android.chileaf.bluetooth.connect.data.DataFilter;
import com.android.chileaf.bluetooth.connect.data.DataMerger;
import com.android.chileaf.bluetooth.connect.data.DataStream;
import com.android.chileaf.bluetooth.connect.exception.BluetoothDisabledException;
import com.android.chileaf.bluetooth.connect.exception.DeviceDisconnectedException;
import com.android.chileaf.bluetooth.connect.exception.InvalidDataException;
import com.android.chileaf.bluetooth.connect.exception.InvalidRequestException;
import com.android.chileaf.bluetooth.connect.exception.RequestFailedException;

public final class ReadRequest
extends SimpleValueRequest<DataReceivedCallback>
implements Operation {
    private ReadProgressCallback progressCallback;
    private DataMerger dataMerger;
    private DataStream buffer;
    private DataFilter filter;
    private int count = 0;

    ReadRequest(@NonNull Request.Type type) {
        super(type);
    }

    ReadRequest(@NonNull Request.Type type, @Nullable BluetoothGattCharacteristic characteristic) {
        super(type, characteristic);
    }

    ReadRequest(@NonNull Request.Type type, @Nullable BluetoothGattDescriptor descriptor) {
        super(type, descriptor);
    }

    @Override
    @NonNull
    ReadRequest setRequestHandler(@NonNull RequestHandler requestHandler) {
        super.setRequestHandler(requestHandler);
        return this;
    }

    @Override
    @NonNull
    public ReadRequest setHandler(@NonNull Handler handler) {
        super.setHandler(handler);
        return this;
    }

    @Override
    @NonNull
    public ReadRequest done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public ReadRequest fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public ReadRequest invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public ReadRequest before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    @NonNull
    public ReadRequest with(@NonNull DataReceivedCallback callback) {
        super.with(callback);
        return this;
    }

    @NonNull
    public ReadRequest filter(@NonNull DataFilter filter) {
        this.filter = filter;
        return this;
    }

    @NonNull
    public ReadRequest merge(@NonNull DataMerger merger) {
        this.dataMerger = merger;
        this.progressCallback = null;
        return this;
    }

    @NonNull
    public ReadRequest merge(@NonNull DataMerger merger, @NonNull ReadProgressCallback callback) {
        this.dataMerger = merger;
        this.progressCallback = callback;
        return this;
    }

    @NonNull
    public <E extends ProfileReadResponse> E awaitValid(@NonNull Class<E> responseClass) throws RequestFailedException, InvalidDataException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException {
        ProfileReadResponse response = (ProfileReadResponse)this.await(responseClass);
        if (!response.isValid()) {
            throw new InvalidDataException(response);
        }
        return (E)response;
    }

    @NonNull
    public <E extends ProfileReadResponse> E awaitValid(@NonNull E response) throws RequestFailedException, InvalidDataException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException {
        this.await(response);
        if (!response.isValid()) {
            throw new InvalidDataException(response);
        }
        return response;
    }

    boolean matches(byte[] packet) {
        return this.filter == null || this.filter.filter(packet);
    }

    void notifyValueChanged(@NonNull BluetoothDevice device, @Nullable byte[] value) {
        DataReceivedCallback valueCallback = (DataReceivedCallback)this.valueCallback;
        if (valueCallback == null) {
            return;
        }
        if (this.dataMerger == null) {
            Data data = new Data(value);
            this.handler.post(() -> valueCallback.onDataReceived(device, data));
        } else {
            this.handler.post(() -> {
                if (this.progressCallback != null) {
                    this.progressCallback.onPacketReceived(device, value, this.count);
                }
            });
            if (this.buffer == null) {
                this.buffer = new DataStream();
            }
            if (this.dataMerger.merge(this.buffer, value, this.count++)) {
                Data data = this.buffer.toData();
                this.handler.post(() -> valueCallback.onDataReceived(device, data));
                this.buffer = null;
                this.count = 0;
            }
        }
    }

    boolean hasMore() {
        return this.count > 0;
    }
}

