/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.util;

import java.nio.charset.Charset;

public class HexUtil {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static char[] encodeHex(byte[] data) {
        return HexUtil.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return HexUtil.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        if (data == null) {
            return new char[0];
        }
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static String encodeHexStr(byte[] data) {
        return HexUtil.encodeHexStr(data, true);
    }

    public static String encodeHexStr(byte[] data, boolean toLowerCase) {
        return HexUtil.encodeHexStr(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static String encodeHexStr(byte[] data, char[] toDigits) {
        return new String(HexUtil.encodeHex(data, toDigits));
    }

    public static byte[] decodeHex(char[] data) {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new RuntimeException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        int i = 0;
        int j = 0;
        while (j < len) {
            int f = HexUtil.toDigit(data[j], j) << 4;
            f |= HexUtil.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    public static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new RuntimeException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return new byte[0];
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(HexUtil.charToByte(hexChars[pos]) << 4 | HexUtil.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static byte[] fromHexString(String hexString) {
        if (null == hexString || "".equals(hexString.trim())) {
            return new byte[0];
        }
        byte[] bytes = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length() / 2; ++i) {
            String hex = hexString.substring(i * 2, i * 2 + 2);
            bytes[i] = (byte)Integer.parseInt(hex, 16);
        }
        return bytes;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String byteArrayToString(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (byte datum : data) {
            char temp = (char)datum;
            if (temp == '\u0000') continue;
            sb.append(temp);
        }
        return sb.toString();
    }

    public static String splitToHexString(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            byte datum = data[i];
            String hex = Integer.toHexString(datum & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            if (datum == 44) {
                char ch = (char)datum;
                sb.append(ch);
                continue;
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String getAsciiString(byte[] data, int offset, int length) {
        return new String(data, offset, length, Charset.forName("US-ASCII"));
    }

    public static String getAsciiString(byte[] data) {
        return HexUtil.getAsciiString(data, 0, data.length);
    }

    public static byte[] stringToBytes(String data) {
        byte[] array = new byte[data.length()];
        for (int i = 0; i < data.length(); ++i) {
            array[i] = (byte)data.charAt(i);
        }
        return array;
    }

    public static String bytes2HexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static String hex2String(String hex) {
        StringBuilder sb = new StringBuilder();
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < hex.length() - 1; i += 2) {
            String output = hex.substring(i, i + 2);
            int str = Integer.parseInt(output, 16);
            sb.append((char)str);
            temp.append(str);
        }
        return sb.toString();
    }

    public static byte[] compose(int ... bytes) {
        byte[] dest = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            dest[i] = (byte)(bytes[i] & 0xFF);
        }
        return dest;
    }

    public static byte[] compose(byte ... bytes) {
        byte[] dest = new byte[bytes.length];
        System.arraycopy(bytes, 0, dest, 0, bytes.length);
        return dest;
    }

    public static byte[] subByte(byte[] source, int length) {
        byte[] dest = new byte[length];
        System.arraycopy(source, 0, dest, 0, dest.length);
        return dest;
    }

    public static byte[] subByte(byte[] source, int start, int end) {
        byte[] dest = new byte[end - start];
        System.arraycopy(source, start, dest, 0, dest.length);
        return dest;
    }

    public static byte[] subByteByLength(byte[] source, int start, int length) {
        byte[] dest = new byte[length];
        System.arraycopy(source, start, dest, 0, dest.length);
        return dest;
    }

    public static int[] append(int source, int[] dest) {
        int[] result = new int[1 + dest.length];
        result[0] = source;
        System.arraycopy(dest, 0, result, 1, dest.length);
        return result;
    }

    public static byte[] append(byte source, byte[] dest) {
        byte[] temp = new byte[]{source};
        return HexUtil.append(temp, dest);
    }

    public static byte[] append(byte[] source, byte dest) {
        byte[] result = new byte[source.length + 1];
        byte[] temp = new byte[]{dest};
        System.arraycopy(source, 0, result, 0, source.length);
        System.arraycopy(temp, 0, result, result.length - 1, 1);
        return result;
    }

    public static byte[] append(byte[] source, byte[] dest) {
        byte[] result = new byte[source.length + dest.length];
        System.arraycopy(source, 0, result, 0, source.length);
        int offset = result.length - dest.length;
        System.arraycopy(dest, 0, result, offset, dest.length);
        return result;
    }

    public static byte[] append(byte[] ... bytes) {
        byte[] dest = new byte[]{};
        for (byte[] outs : bytes) {
            dest = HexUtil.append(dest, outs);
        }
        return dest;
    }
}

