/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.util;

import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LogUtil {
    private static final Tree TREE_OF_SOULS = new DebugTree();

    public static void v(@NonNull String message, Object ... args) {
        TREE_OF_SOULS.v(message, args);
    }

    public static void v(Throwable t, @NonNull String message, Object ... args) {
        TREE_OF_SOULS.v(t, message, args);
    }

    public static void v(Throwable t) {
        TREE_OF_SOULS.v(t);
    }

    public static void d(@NonNull String message, Object ... args) {
        TREE_OF_SOULS.d(message, args);
    }

    public static void d(Throwable t, @NonNull String message, Object ... args) {
        TREE_OF_SOULS.d(t, message, args);
    }

    public static void d(Throwable t) {
        TREE_OF_SOULS.d(t);
    }

    public static void i(@NonNull String message, Object ... args) {
        TREE_OF_SOULS.i(message, args);
    }

    public static void i(Throwable t, @NonNull String message, Object ... args) {
        TREE_OF_SOULS.i(t, message, args);
    }

    public static void i(Throwable t) {
        TREE_OF_SOULS.i(t);
    }

    public static void w(@NonNull String message, Object ... args) {
        TREE_OF_SOULS.w(message, args);
    }

    public static void w(Throwable t, @NonNull String message, Object ... args) {
        TREE_OF_SOULS.w(t, message, args);
    }

    public static void w(Throwable t) {
        TREE_OF_SOULS.w(t);
    }

    public static void e(@NonNull String message, Object ... args) {
        TREE_OF_SOULS.e(message, args);
    }

    public static void e(Throwable t, @NonNull String message, Object ... args) {
        TREE_OF_SOULS.e(t, message, args);
    }

    public static void e(Throwable t) {
        TREE_OF_SOULS.e(t);
    }

    public static void wtf(@NonNull String message, Object ... args) {
        TREE_OF_SOULS.wtf(message, args);
    }

    public static void wtf(Throwable t, @NonNull String message, Object ... args) {
        TREE_OF_SOULS.wtf(t, message, args);
    }

    public static void wtf(Throwable t) {
        TREE_OF_SOULS.wtf(t);
    }

    public static void log(int priority, @NonNull String message, Object ... args) {
        TREE_OF_SOULS.log(priority, message, args);
    }

    public static void log(int priority, Throwable t, @NonNull String message, Object ... args) {
        TREE_OF_SOULS.log(priority, t, message, args);
    }

    public static void log(int priority, Throwable t) {
        TREE_OF_SOULS.log(priority, t);
    }

    @NonNull
    public static Tree tag(String tag) {
        TREE_OF_SOULS.explicitTag.set(tag);
        return TREE_OF_SOULS;
    }

    public static void setDebug(boolean debug) {
        TREE_OF_SOULS.setDebug(debug);
    }

    private LogUtil() {
        throw new AssertionError((Object)"No instances.");
    }

    public static class DebugTree
    extends Tree {
        private static final int MAX_LOG_LENGTH = 4000;
        private static final int MAX_TAG_LENGTH = 23;
        private static final int CALL_STACK_INDEX = 5;
        private static final Pattern ANONYMOUS_CLASS = Pattern.compile("(\\$\\d+)+$");

        @Nullable
        protected String createStackElementTag(@NonNull StackTraceElement element) {
            String tag = element.getClassName();
            Matcher m = ANONYMOUS_CLASS.matcher(tag);
            if (m.find()) {
                tag = m.replaceAll("");
            }
            if ((tag = tag.substring(tag.lastIndexOf(46) + 1)).length() <= 23 || Build.VERSION.SDK_INT >= 24) {
                return tag;
            }
            return tag.substring(0, 23);
        }

        @Override
        final String getTag() {
            String tag = super.getTag();
            if (tag != null) {
                return tag;
            }
            StackTraceElement[] stackTrace = new Throwable().getStackTrace();
            if (stackTrace.length <= 5) {
                throw new IllegalStateException("Synthetic stacktrace didn't have enough elements: are you using proguard?");
            }
            return this.createStackElementTag(stackTrace[5]);
        }

        @Override
        protected void log(int priority, String tag, @NonNull String message, Throwable t) {
            if (message.length() < 4000) {
                if (priority == 7) {
                    Log.wtf((String)tag, (String)message);
                } else {
                    Log.println((int)priority, (String)tag, (String)message);
                }
                return;
            }
            int length = message.length();
            for (int i = 0; i < length; ++i) {
                int end;
                int newline = message.indexOf(10, i);
                newline = newline != -1 ? newline : length;
                do {
                    end = Math.min(newline, i + 4000);
                    String part = message.substring(i, end);
                    if (priority == 7) {
                        Log.wtf((String)tag, (String)part);
                        continue;
                    }
                    Log.println((int)priority, (String)tag, (String)part);
                } while ((i = end) < newline);
            }
        }
    }

    public static abstract class Tree {
        private boolean isDebug;
        private final ThreadLocal<String> explicitTag = new ThreadLocal();

        @Nullable
        String getTag() {
            String tag = this.explicitTag.get();
            if (tag != null) {
                this.explicitTag.remove();
            }
            return tag;
        }

        public void v(String message, Object ... args) {
            this.prepareLog(2, null, message, args);
        }

        public void v(Throwable t, String message, Object ... args) {
            this.prepareLog(2, t, message, args);
        }

        public void v(Throwable t) {
            this.prepareLog(2, t, null, new Object[0]);
        }

        public void d(String message, Object ... args) {
            this.prepareLog(3, null, message, args);
        }

        public void d(Throwable t, String message, Object ... args) {
            this.prepareLog(3, t, message, args);
        }

        public void d(Throwable t) {
            this.prepareLog(3, t, null, new Object[0]);
        }

        public void i(String message, Object ... args) {
            this.prepareLog(4, null, message, args);
        }

        public void i(Throwable t, String message, Object ... args) {
            this.prepareLog(4, t, message, args);
        }

        public void i(Throwable t) {
            this.prepareLog(4, t, null, new Object[0]);
        }

        public void w(String message, Object ... args) {
            this.prepareLog(5, null, message, args);
        }

        public void w(Throwable t, String message, Object ... args) {
            this.prepareLog(5, t, message, args);
        }

        public void w(Throwable t) {
            this.prepareLog(5, t, null, new Object[0]);
        }

        public void e(String message, Object ... args) {
            this.prepareLog(6, null, message, args);
        }

        public void e(Throwable t, String message, Object ... args) {
            this.prepareLog(6, t, message, args);
        }

        public void e(Throwable t) {
            this.prepareLog(6, t, null, new Object[0]);
        }

        public void wtf(String message, Object ... args) {
            this.prepareLog(7, null, message, args);
        }

        public void wtf(Throwable t, String message, Object ... args) {
            this.prepareLog(7, t, message, args);
        }

        public void wtf(Throwable t) {
            this.prepareLog(7, t, null, new Object[0]);
        }

        public void log(int priority, String message, Object ... args) {
            this.prepareLog(priority, null, message, args);
        }

        public void log(int priority, Throwable t, String message, Object ... args) {
            this.prepareLog(priority, t, message, args);
        }

        public void log(int priority, Throwable t) {
            this.prepareLog(priority, t, null, new Object[0]);
        }

        public void setDebug(boolean debug) {
            this.isDebug = debug;
        }

        private void prepareLog(int priority, Throwable t, String message, Object ... args) {
            String tag = this.getTag();
            if (!this.isDebug) {
                return;
            }
            if (message != null && message.length() == 0) {
                message = null;
            }
            if (message == null) {
                if (t == null) {
                    return;
                }
                message = this.getStackTraceString(t);
            } else {
                if (args != null && args.length > 0) {
                    message = this.formatMessage(message, args);
                }
                if (t != null) {
                    message = message + "\n" + this.getStackTraceString(t);
                }
            }
            this.log(priority, tag, message, t);
        }

        protected String formatMessage(@NonNull String message, @NonNull Object[] args) {
            return String.format(message, args);
        }

        private String getStackTraceString(Throwable t) {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter((Writer)sw, false);
            t.printStackTrace(pw);
            pw.flush();
            return sw.toString();
        }

        protected abstract void log(int var1, @Nullable String var2, @NonNull String var3, @Nullable Throwable var4);
    }
}

