/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.bluetooth.connect;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.os.Handler;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.chileaf.bluetooth.connect.Bytes;
import com.android.chileaf.bluetooth.connect.Request;
import com.android.chileaf.bluetooth.connect.RequestHandler;
import com.android.chileaf.bluetooth.connect.SimpleRequest;
import com.android.chileaf.bluetooth.connect.callback.BeforeCallback;
import com.android.chileaf.bluetooth.connect.callback.FailCallback;
import com.android.chileaf.bluetooth.connect.callback.InvalidRequestCallback;
import com.android.chileaf.bluetooth.connect.callback.SuccessCallback;

public final class SetValueRequest
extends SimpleRequest {
    private final byte[] data;
    private boolean longReadSupported = true;

    SetValueRequest(@NonNull Request.Type type, @Nullable BluetoothGattCharacteristic characteristic, @Nullable byte[] data, @IntRange(from=0L) int offset, @IntRange(from=0L) int length) {
        super(type, characteristic);
        this.data = Bytes.copy(data, offset, length);
    }

    SetValueRequest(@NonNull Request.Type type, @Nullable BluetoothGattDescriptor descriptor, @Nullable byte[] data, @IntRange(from=0L) int offset, @IntRange(from=0L) int length) {
        super(type, descriptor);
        this.data = Bytes.copy(data, offset, length);
    }

    @Override
    @NonNull
    SetValueRequest setRequestHandler(@NonNull RequestHandler requestHandler) {
        super.setRequestHandler(requestHandler);
        return this;
    }

    @Override
    @NonNull
    public SetValueRequest setHandler(@NonNull Handler handler) {
        super.setHandler(handler);
        return this;
    }

    @Override
    @NonNull
    public SetValueRequest done(@NonNull SuccessCallback callback) {
        super.done(callback);
        return this;
    }

    @Override
    @NonNull
    public SetValueRequest fail(@NonNull FailCallback callback) {
        super.fail(callback);
        return this;
    }

    @Override
    @NonNull
    public SetValueRequest invalid(@NonNull InvalidRequestCallback callback) {
        super.invalid(callback);
        return this;
    }

    @Override
    @NonNull
    public SetValueRequest before(@NonNull BeforeCallback callback) {
        super.before(callback);
        return this;
    }

    @NonNull
    public SetValueRequest allowLongRead(boolean longReadSupported) {
        this.longReadSupported = longReadSupported;
        return this;
    }

    byte[] getData(@IntRange(from=23L, to=517L) int mtu) {
        int maxLength;
        int n = maxLength = this.longReadSupported ? 512 : mtu - 3;
        if (this.data.length < maxLength) {
            return this.data;
        }
        return Bytes.copy(this.data, 0, maxLength);
    }
}

