/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.fitness.callback;

import android.bluetooth.BluetoothDevice;
import android.os.Parcel;
import androidx.annotation.NonNull;
import com.android.chileaf.bluetooth.connect.callback.profile.ProfileReadResponse;
import com.android.chileaf.bluetooth.connect.data.Data;
import com.android.chileaf.bluetooth.connect.utils.ParserUtils;
import com.android.chileaf.fitness.callback.BloodOxygenCallback;
import com.android.chileaf.fitness.callback.BluetoothStatusCallback;
import com.android.chileaf.fitness.callback.BodySportCallback;
import com.android.chileaf.fitness.callback.HeartRateStatusCallback;
import com.android.chileaf.fitness.callback.HistoryOfHRDataCallback;
import com.android.chileaf.fitness.callback.HistoryOfHRRecordCallback;
import com.android.chileaf.fitness.callback.HistoryOfRRDataCallback;
import com.android.chileaf.fitness.callback.HistoryOfRRRecordCallback;
import com.android.chileaf.fitness.callback.HistoryOfSportCallback;
import com.android.chileaf.fitness.callback.IntervalStepCallback;
import com.android.chileaf.fitness.callback.SingleTapRecordCallback;
import com.android.chileaf.fitness.callback.TemperatureCallback;
import com.android.chileaf.fitness.callback.UserInfoCallback;
import com.android.chileaf.model.HistoryOfHeartRate;
import com.android.chileaf.model.HistoryOfRecord;
import com.android.chileaf.model.HistoryOfRespiratoryRate;
import com.android.chileaf.model.HistoryOfSport;
import com.android.chileaf.model.IntervalStep;
import com.android.chileaf.util.DateUtil;
import com.android.chileaf.util.HexUtil;
import com.android.chileaf.util.LogUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class WearReceivedDataCallback
extends ProfileReadResponse
implements UserInfoCallback,
BodySportCallback,
BluetoothStatusCallback,
HistoryOfSportCallback,
HistoryOfHRRecordCallback,
HistoryOfHRDataCallback,
HistoryOfRRRecordCallback,
HistoryOfRRDataCallback,
IntervalStepCallback,
SingleTapRecordCallback,
HeartRateStatusCallback,
BloodOxygenCallback,
TemperatureCallback {
    private static final long END_TAG = 0xFFFFFFFFL;
    private long mCacheStamp = 0L;
    private volatile long mRecordTag = 0L;
    private volatile boolean isRecord = false;
    private volatile boolean isReceived = false;
    private final List<Data> mCachePackages = new ArrayList<Data>();
    private long mStamp = 0L;
    private boolean isCL833 = false;
    private boolean isStamp = false;
    private final List<Data> mPackages = new ArrayList<Data>();
    private List<HistoryOfSport> mHistoryOfSports;
    private List<HistoryOfRecord> mHistoryOfRecords;
    private List<HistoryOfHeartRate> mHistoryOfHeartRates;
    private List<HistoryOfRecord> mRespiratoryRatesRecords;
    private List<HistoryOfRespiratoryRate> mHistoryOfRespiratoryRates;
    private List<IntervalStep> mIntervalSteps;
    private List<HistoryOfRecord> mSingleTapRecords;
    public static final int TYPE_SPORT = 2;
    public static final int TYPE_HEART = 4;
    public static final int TYPE_HEARTS = 6;
    public static final int TYPE_HEART_RR = 8;
    public static final int TYPE_HEART_RRS = 16;
    public static final int TYPE_INTERVAL = 18;
    public static final int TYPE_SINGLE_TAP = 20;

    public WearReceivedDataCallback() {
    }

    protected WearReceivedDataCallback(Parcel in) {
        super(in);
    }

    @Override
    public void onDataReceived(@NonNull BluetoothDevice device, @NonNull Data data) {
        boolean validate;
        super.onDataReceived(device, data);
        boolean bl = validate = data.getIntValue(17, 1).intValue() == data.size();
        if (!validate) {
            this.onInvalidDataReceived(device, data);
            LogUtil.w("onDataReceived:length:%s", data.size());
            return;
        }
        byte[] value = data.getValue();
        int mode = data.getIntValue(17, 2);
        try {
            if (mode == 3) {
                int age = this.getIntParse(value, 5, 1);
                int sex = this.getIntParse(value, 6, 1);
                int weight = this.getIntParse(value, 7, 1);
                int height = this.getIntParse(value, 8, 1);
                long mobile = this.getLongParse(value, 9, 5);
                this.onUserInfoReceived(device, age, sex, weight, height, mobile);
            } else if (mode == 21) {
                int step = this.getIntParse(value, 3, 3);
                int distance = this.getIntParse(value, 6, 3);
                int calorie = this.getIntParse(value, 9, 3);
                this.onSportReceived(device, step, distance, calorie);
            } else if (mode == 63) {
                int status = this.getIntParse(value, 3, 1);
                this.onBluetoothStatusReceived(device, status == 1);
            } else if (mode == 22) {
                if (this.mHistoryOfSports == null) {
                    this.mHistoryOfSports = new ArrayList<HistoryOfSport>();
                }
                long utcTag = this.getLongParse(value, 3, 4);
                if (this.isCL833) {
                    byte[] slice = this.subSlice(3, value);
                    this.parseSportHistory(slice);
                    Collections.reverse(this.mHistoryOfSports);
                    this.onHistoryOfSportReceived(device, this.mHistoryOfSports);
                    this.mHistoryOfSports.clear();
                } else if (utcTag != 0xFFFFFFFFL) {
                    this.mPackages.add(data);
                } else {
                    for (int index = 0; index < this.mPackages.size(); ++index) {
                        byte[] slice = this.subSlice(3, this.mPackages.get(index).getValue());
                        this.parseSportHistory(slice);
                        LogUtil.d("HistoryOfSport index:%d values:%s", index, ParserUtils.parse(slice));
                    }
                    this.onHistoryOfSportReceived(device, this.mHistoryOfSports);
                    this.mHistoryOfSports.clear();
                    this.mPackages.clear();
                }
            } else if (mode == 33) {
                long utcTag;
                if (this.mHistoryOfRecords == null) {
                    this.mHistoryOfRecords = new ArrayList<HistoryOfRecord>();
                }
                if ((utcTag = this.getLongParse(value, 3, 4)) != 0xFFFFFFFFL) {
                    this.mPackages.add(data);
                } else {
                    for (int index = 0; index < this.mPackages.size(); ++index) {
                        byte[] slice = this.subSlice(3, this.mPackages.get(index).getValue());
                        LogUtil.d("mHistoryOfRecords index:%d values:%s", index, ParserUtils.parse(slice));
                        for (int i = 0; i < slice.length / 4; ++i) {
                            int offset = i * 4;
                            long stamp = this.getLongParse(slice, offset, 4);
                            long record = DateUtil.restoreZoneUTC(stamp);
                            this.mHistoryOfRecords.add(new HistoryOfRecord(stamp, record));
                            LogUtil.d("mHistoryOfRecords index:%d record:%s", i, stamp);
                        }
                    }
                    this.onHistoryOfHRRecordReceived(device, this.mHistoryOfRecords);
                    this.mHistoryOfRecords.clear();
                    this.mPackages.clear();
                }
            } else if (mode == 34 || mode == 35) {
                if (this.mHistoryOfHeartRates == null) {
                    this.mHistoryOfHeartRates = new ArrayList<HistoryOfHeartRate>();
                }
                if (!this.isRecord) {
                    if (mode == 34) {
                        long record = this.getLongParse(value, 3, 4);
                        LogUtil.d("0x22/0x23 record == mRecordTag:%s record:%s  tag:%s", this.isRecord, record, this.mRecordTag);
                        if (record == this.mRecordTag) {
                            this.mCacheStamp = record;
                            this.isReceived = true;
                            this.mCachePackages.add(data);
                        } else if (this.isReceived) {
                            if (record < 102400L) {
                                this.mCachePackages.add(data);
                                LogUtil.d("0x22/0x23 isReceived && record < Integer.MAX_VALUE:%s record:%s  tag:%s", this.isRecord, record, this.mRecordTag);
                            } else {
                                this.isRecord = true;
                                this.parseRecordHistory(device);
                                LogUtil.d("0x22/0x23 else :%s record:%s  tag:%s", this.isRecord, record, this.mRecordTag);
                            }
                        }
                    }
                    if (mode == 35) {
                        this.isRecord = true;
                        this.parseRecordHistory(device);
                    }
                }
            } else if (mode == 36) {
                long utcTag;
                if (this.mRespiratoryRatesRecords == null) {
                    this.mRespiratoryRatesRecords = new ArrayList<HistoryOfRecord>();
                }
                if ((utcTag = this.getLongParse(value, 3, 4)) != 0xFFFFFFFFL) {
                    this.mPackages.add(data);
                } else {
                    int length = 4;
                    for (int index = 0; index < this.mPackages.size(); ++index) {
                        byte[] slice = this.subSlice(3, this.mPackages.get(index).getValue());
                        LogUtil.d("mRespiratoryRatesRecords index:%d values:%s", index, ParserUtils.parse(slice));
                        for (int i = 0; i < slice.length / length; ++i) {
                            int offset = i * length;
                            long stamp = this.getLongParse(slice, offset, 4);
                            long record = DateUtil.restoreZoneUTC(stamp);
                            HistoryOfRecord historyRecord = new HistoryOfRecord(stamp, record);
                            this.mRespiratoryRatesRecords.add(historyRecord);
                        }
                    }
                    this.onHistoryOfRRRecordReceived(device, this.mRespiratoryRatesRecords);
                    LogUtil.d("onHistoryOfRRRecordReceived size:%d", this.mRespiratoryRatesRecords.size());
                    this.mRespiratoryRatesRecords.clear();
                    this.mPackages.clear();
                }
            } else if (mode == 37 || mode == 38) {
                if (this.mHistoryOfRespiratoryRates == null) {
                    this.mHistoryOfRespiratoryRates = new ArrayList<HistoryOfRespiratoryRate>();
                }
                if (mode == 37) {
                    if (!this.isStamp) {
                        this.mStamp = this.getLongParse(value, 3, 4);
                        this.isStamp = true;
                    }
                    this.mPackages.add(data);
                }
                if (mode == 38) {
                    int length = 4;
                    for (int index = 0; index < this.mPackages.size(); ++index) {
                        byte[] slice = this.subSlice(7, this.mPackages.get(index).getValue());
                        LogUtil.d("index:%d HistoryOfRespiratoryRates mValues:%s", index, ParserUtils.parse(slice));
                        for (int i = 0; i < slice.length / length; ++i) {
                            int offset = i * length;
                            int heart = this.getIntParse(slice, offset, 2);
                            int respiratory = this.getIntParse(slice, offset + 2, 2);
                            long stamp = DateUtil.restoreZoneUTC(this.mStamp);
                            HistoryOfRespiratoryRate respiratoryRate = new HistoryOfRespiratoryRate(stamp, heart, respiratory);
                            this.mHistoryOfRespiratoryRates.add(respiratoryRate);
                            ++this.mStamp;
                        }
                    }
                    LogUtil.d("onHistoryOfRRDataReceived :%s", this.mHistoryOfRespiratoryRates.toString());
                    this.onHistoryOfRRDataReceived(device, this.mHistoryOfRespiratoryRates);
                    this.mHistoryOfRespiratoryRates.clear();
                    this.mPackages.clear();
                    this.isStamp = false;
                    this.mStamp = 0L;
                }
            } else if (mode == 55) {
                if (value[1] <= 6) {
                    return;
                }
                int bSwitch = this.getIntParse(value, 3, 1);
                if (value[1] <= 8) {
                    return;
                }
                int blValue = this.getIntParse(value, 4, 1);
                int gesture = this.getIntParse(value, 5, 1);
                int piValue = this.getIntParse(value, 6, 1);
                int onwrist = this.getIntParse(value, 7, 1);
                this.onBloodOxygenReceived(device, bSwitch, String.valueOf(blValue), gesture, piValue, onwrist);
            } else if (mode == 56) {
                float BadSituation = (float)this.getIntParse(value, 3, 2) / 10.0f;
                float wrist = (float)this.getIntParse(value, 5, 2) / 10.0f;
                float body = (float)this.getIntParse(value, 7, 2) / 10.0f;
                this.onTemperatureReceived(device, BadSituation, wrist, body);
            } else if (mode == 64 || mode == 65) {
                if (this.mIntervalSteps == null) {
                    this.mIntervalSteps = new ArrayList<IntervalStep>();
                }
                if (mode == 64) {
                    this.mPackages.add(data);
                }
                if (mode == 65) {
                    for (int index = 0; index < this.mPackages.size(); ++index) {
                        byte[] slice = this.subSlice(3, this.mPackages.get(index).getValue());
                        LogUtil.d("mIntervalSteps index:%d values:%s", index, ParserUtils.parse(slice));
                        for (int i = 0; i < slice.length / 8; ++i) {
                            int offset = i * 8;
                            long stamp = DateUtil.restoreZoneUTC(this.getLongParse(slice, offset, 4));
                            int step = this.getIntParse(slice, offset + 4, 4);
                            IntervalStep intervalStep = new IntervalStep(stamp, step);
                            this.mIntervalSteps.add(intervalStep);
                        }
                    }
                    this.onIntervalStepReceived(device, this.mIntervalSteps);
                    this.mIntervalSteps.clear();
                    this.mPackages.clear();
                }
            } else if (mode == 66 || mode == 67) {
                if (this.mSingleTapRecords == null) {
                    this.mSingleTapRecords = new ArrayList<HistoryOfRecord>();
                }
                if (mode == 66) {
                    this.mPackages.add(data);
                }
                if (mode == 67) {
                    for (int index = 0; index < this.mPackages.size(); ++index) {
                        byte[] slice = this.subSlice(3, this.mPackages.get(index).getValue());
                        LogUtil.d("mSingleTapRecords index:%d values:%s", index, ParserUtils.parse(slice));
                        for (int i = 0; i < slice.length / 4; ++i) {
                            int offset = i * 4;
                            long stamp = this.getLongParse(slice, offset, 4);
                            long record = DateUtil.restoreZoneUTC(stamp);
                            this.mSingleTapRecords.add(new HistoryOfRecord(stamp, record));
                        }
                    }
                    this.onSingleTapRecordReceived(device, this.mSingleTapRecords);
                    this.mSingleTapRecords.clear();
                    this.mPackages.clear();
                }
            } else if (mode == 70) {
                int min = this.getIntParse(value, 4, 1);
                int max = this.getIntParse(value, 5, 1);
                int goal = this.getIntParse(value, 6, 1);
                this.onHeartRateStatusReceived(device, min, max, goal);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setCL833(boolean isCL833) {
        this.isCL833 = isCL833;
    }

    public void clearType(int type) {
        switch (type) {
            case 2: {
                if (this.mHistoryOfSports == null) break;
                this.mHistoryOfSports.clear();
                break;
            }
            case 4: {
                if (this.mHistoryOfRecords == null) break;
                this.mHistoryOfRecords.clear();
                break;
            }
            case 6: {
                if (this.mHistoryOfHeartRates == null) break;
                this.mHistoryOfHeartRates.clear();
                break;
            }
            case 8: {
                if (this.mRespiratoryRatesRecords == null) break;
                this.mRespiratoryRatesRecords.clear();
                break;
            }
            case 16: {
                if (this.mHistoryOfRespiratoryRates == null) break;
                this.mHistoryOfRespiratoryRates.clear();
                break;
            }
            case 18: {
                if (this.mIntervalSteps == null) break;
                this.mIntervalSteps.clear();
                break;
            }
            case 20: {
                if (this.mSingleTapRecords == null) break;
                this.mSingleTapRecords.clear();
                break;
            }
        }
        this.mPackages.clear();
    }

    public void setRecordTag(long record) {
        this.isRecord = false;
        this.isReceived = false;
        this.mRecordTag = record;
    }

    private void parseSportHistory(byte[] value) {
        LogUtil.d("HistoryOfSport length:%d values:%s", value.length, ParserUtils.parse(value));
        for (int i = 0; i < value.length / 10; ++i) {
            int offset = i * 10;
            long stamp = this.getLongParse(value, offset, 4);
            long step = this.getLongParse(value, offset + 4, 3);
            long calorie = this.getLongParse(value, offset + 7, 3);
            stamp = DateUtil.restoreZoneUTC(stamp);
            this.mHistoryOfSports.add(new HistoryOfSport(stamp, step, calorie));
        }
    }

    private void parseRecordHistory(BluetoothDevice device) {
        for (int index = 0; index < this.mCachePackages.size(); ++index) {
            byte[] slice = this.subSlice(3, this.mCachePackages.get(index).getValue());
            LogUtil.d("mHistoryOfHeartRates index:%d values:%s", index, ParserUtils.parse(slice));
            for (int i = 4; i < slice.length; ++i) {
                int heart = this.getIntParse(slice, i, 1);
                long stamp = DateUtil.restoreZoneUTC(this.mCacheStamp);
                HistoryOfHeartRate heartRate = new HistoryOfHeartRate(stamp, heart);
                this.mHistoryOfHeartRates.add(heartRate);
                ++this.mCacheStamp;
            }
        }
        this.onHistoryOfHRDataReceived(device, this.mHistoryOfHeartRates);
        this.mHistoryOfHeartRates.clear();
        this.mCachePackages.clear();
    }

    private synchronized byte[] subSlice(int start, byte[] value) {
        return HexUtil.subByte(value, start, value.length - 1);
    }

    private long getLongParse(byte[] bytes, int pos, int len) {
        long val = 0L;
        len += pos;
        for (int i = pos; i < len; ++i) {
            val <<= 8;
            val |= (long)bytes[i] & 0xFFL;
        }
        return val;
    }

    private int getIntParse(byte[] bytes, int pos, int len) {
        int val = 0;
        len += pos;
        for (int i = pos; i < len; ++i) {
            val <<= 8;
            val |= bytes[i] & 0xFF;
        }
        return val;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DataType {
    }
}

