/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf.bluetooth.connect;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.os.Handler;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.chileaf.bluetooth.connect.Request;
import com.android.chileaf.bluetooth.connect.RequestHandler;
import com.android.chileaf.bluetooth.connect.callback.FailCallback;
import com.android.chileaf.bluetooth.connect.callback.SuccessCallback;
import com.android.chileaf.bluetooth.connect.exception.BluetoothDisabledException;
import com.android.chileaf.bluetooth.connect.exception.DeviceDisconnectedException;
import com.android.chileaf.bluetooth.connect.exception.InvalidRequestException;
import com.android.chileaf.bluetooth.connect.exception.RequestFailedException;

public abstract class TimeoutableRequest
extends Request {
    private Runnable timeoutCallback;
    protected long timeout;

    TimeoutableRequest(@NonNull Request.Type type) {
        super(type);
    }

    TimeoutableRequest(@NonNull Request.Type type, @Nullable BluetoothGattCharacteristic characteristic) {
        super(type, characteristic);
    }

    TimeoutableRequest(@NonNull Request.Type type, @Nullable BluetoothGattDescriptor descriptor) {
        super(type, descriptor);
    }

    @Override
    @NonNull
    TimeoutableRequest setRequestHandler(@NonNull RequestHandler requestHandler) {
        super.setRequestHandler(requestHandler);
        return this;
    }

    @Override
    @NonNull
    public TimeoutableRequest setHandler(@NonNull Handler handler) {
        super.setHandler(handler);
        return this;
    }

    @NonNull
    public TimeoutableRequest timeout(@IntRange(from=0L) long timeout) {
        if (this.timeoutCallback != null) {
            throw new IllegalStateException("Request already started");
        }
        this.timeout = timeout;
        return this;
    }

    @Override
    public final void enqueue() {
        super.enqueue();
    }

    @Deprecated
    public final void enqueue(@IntRange(from=0L) long timeout) {
        this.timeout(timeout).enqueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void await() throws RequestFailedException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException, InterruptedException {
        TimeoutableRequest.assertNotMainThread();
        SuccessCallback sc = this.successCallback;
        FailCallback fc = this.failCallback;
        try {
            this.syncLock.close();
            Request.RequestCallback callback = new Request.RequestCallback(this);
            this.done(callback).fail(callback).invalid(callback).enqueue();
            if (!this.syncLock.block(this.timeout)) {
                throw new InterruptedException();
            }
            if (!callback.isSuccess()) {
                if (callback.status == -1) {
                    throw new DeviceDisconnectedException();
                }
                if (callback.status == -100) {
                    throw new BluetoothDisabledException();
                }
                if (callback.status == -1000000) {
                    throw new InvalidRequestException(this);
                }
                throw new RequestFailedException(this, callback.status);
            }
        }
        finally {
            this.successCallback = sc;
            this.failCallback = fc;
        }
    }

    @Deprecated
    public final void await(@IntRange(from=0L) long timeout) throws RequestFailedException, InterruptedException, DeviceDisconnectedException, BluetoothDisabledException, InvalidRequestException {
        this.timeout(timeout).await();
    }

    @Override
    void notifyStarted(@NonNull BluetoothDevice device) {
        if (this.timeout > 0L) {
            this.timeoutCallback = () -> {
                this.timeoutCallback = null;
                if (!this.finished) {
                    this.notifyFail(device, -5);
                    this.requestHandler.onRequestTimeout(this);
                }
            };
            this.handler.postDelayed(this.timeoutCallback, this.timeout);
        }
        super.notifyStarted(device);
    }

    @Override
    void notifySuccess(@NonNull BluetoothDevice device) {
        if (!this.finished) {
            this.handler.removeCallbacks(this.timeoutCallback);
            this.timeoutCallback = null;
        }
        super.notifySuccess(device);
    }

    @Override
    void notifyFail(@NonNull BluetoothDevice device, int status) {
        if (!this.finished) {
            this.handler.removeCallbacks(this.timeoutCallback);
            this.timeoutCallback = null;
        }
        super.notifyFail(device, status);
    }

    @Override
    void notifyInvalidRequest() {
        if (!this.finished) {
            this.handler.removeCallbacks(this.timeoutCallback);
            this.timeoutCallback = null;
        }
        super.notifyInvalidRequest();
    }
}

