/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.os.ParcelUuid;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.chileaf.bluetooth.connect.BleManager;
import com.android.chileaf.bluetooth.connect.data.Data;
import com.android.chileaf.bluetooth.scanner.BluetoothLeScannerCompat;
import com.android.chileaf.bluetooth.scanner.ScanCallback;
import com.android.chileaf.bluetooth.scanner.ScanFilter;
import com.android.chileaf.bluetooth.scanner.ScanResult;
import com.android.chileaf.bluetooth.scanner.ScanSettings;
import com.android.chileaf.fitness.FitnessManager;
import com.android.chileaf.fitness.callback.BloodOxygenCallback;
import com.android.chileaf.fitness.callback.BluetoothStatusCallback;
import com.android.chileaf.fitness.callback.BodySportCallback;
import com.android.chileaf.fitness.callback.CustomDataReceivedCallback;
import com.android.chileaf.fitness.callback.HeartRateStatusCallback;
import com.android.chileaf.fitness.callback.HistoryOfHRDataCallback;
import com.android.chileaf.fitness.callback.HistoryOfHRRecordCallback;
import com.android.chileaf.fitness.callback.HistoryOfRRDataCallback;
import com.android.chileaf.fitness.callback.HistoryOfRRRecordCallback;
import com.android.chileaf.fitness.callback.HistoryOfSportCallback;
import com.android.chileaf.fitness.callback.IntervalStepCallback;
import com.android.chileaf.fitness.callback.PPGDataCallback;
import com.android.chileaf.fitness.callback.SingleTapRecordCallback;
import com.android.chileaf.fitness.callback.TemperatureCallback;
import com.android.chileaf.fitness.callback.UserInfoCallback;
import com.android.chileaf.fitness.callback.WearManagerCallbacks;
import com.android.chileaf.fitness.callback.WearReceivedDataCallback;
import com.android.chileaf.fitness.common.FilterScanCallback;
import com.android.chileaf.fitness.common.heart.BodySensorLocationDataCallback;
import com.android.chileaf.fitness.common.heart.HeartRateMeasurementCallback;
import com.android.chileaf.fitness.common.heart.HeartRateMeasurementDataCallback;
import com.android.chileaf.fitness.common.parser.BodySensorLocationParser;
import com.android.chileaf.fitness.common.parser.HeartRateMeasurementParser;
import com.android.chileaf.model.HistoryOfHeartRate;
import com.android.chileaf.model.HistoryOfRecord;
import com.android.chileaf.model.HistoryOfRespiratoryRate;
import com.android.chileaf.model.HistoryOfSport;
import com.android.chileaf.model.IntervalStep;
import com.android.chileaf.util.DateUtil;
import com.android.chileaf.util.HexUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class WearManager
extends FitnessManager<WearManagerCallbacks> {
    private static final UUID HR_SERVICE_UUID = UUID.fromString("0000180D-0000-1000-8000-00805f9b34fb");
    private static final UUID BODY_SENSOR_LOCATION_CHARACTERISTIC_UUID = UUID.fromString("00002A38-0000-1000-8000-00805f9b34fb");
    private static final UUID HEART_RATE_MEASUREMENT_CHARACTERISTIC_UUID = UUID.fromString("00002A37-0000-1000-8000-00805f9b34fb");
    private static final String[] MODE_NAMES = new String[]{"CL831", "CL880N"};
    private WearScanCallback mScanCallback;
    private static WearManager managerInstance = null;
    private String[] mFilterNames = null;
    private BluetoothGattCharacteristic mBodySensorLocationCharacteristic;
    private BluetoothGattCharacteristic mHeartRateCharacteristic;
    private UserInfoCallback mUserInfoCallback;
    private BodySportCallback mBodySportCallback;
    private HeartRateMeasurementCallback mHeartRateMeasurementCallback;
    private HistoryOfSportCallback mHistoryOfSportCallback;
    private HistoryOfHRRecordCallback mHistoryOfHRRecordCallback;
    private HistoryOfHRDataCallback mHistoryOfHRDataCallback;
    private HistoryOfRRRecordCallback mHistoryOfRRRecordCallback;
    private HistoryOfRRDataCallback mHistoryOfRRDataCallback;
    private IntervalStepCallback mIntervalStepsCallback;
    private SingleTapRecordCallback mSingleTapRecordCallback;
    private BluetoothStatusCallback mBluetoothStatusCallback;
    private CustomDataReceivedCallback mCustomDataReceivedCallback;
    private HeartRateStatusCallback mHeartRateStatusCallback;
    private BloodOxygenCallback mBloodOxygenCallback;
    private TemperatureCallback mTemperatureCallback;
    private PPGDataCallback mPPGDataCallback;
    private final BodySensorLocationDataCallback mBodySensorLocationDataCallback = new BodySensorLocationDataCallback(){

        @Override
        public void onBodySensorLocationReceived(@NonNull BluetoothDevice device, int sensorLocation) {
            ((WearManagerCallbacks)WearManager.this.mCallbacks).onBodySensorLocationReceived(device, sensorLocation);
        }

        @Override
        public void onDataReceived(@NonNull BluetoothDevice device, @NonNull Data data) {
            WearManager.this.log(3, String.format("%s received", BodySensorLocationParser.parse(data)));
            super.onDataReceived(device, data);
        }
    };
    private final HeartRateMeasurementDataCallback mHeartRateMeasureDataCallback = new HeartRateMeasurementDataCallback(){

        @Override
        public void onHeartRateMeasurementReceived(@NonNull BluetoothDevice device, int heartRate, @Nullable Boolean contactDetected, @Nullable Integer energyExpanded, @Nullable List<Integer> rrIntervals) {
            ((WearManagerCallbacks)WearManager.this.mCallbacks).onHeartRateMeasurementReceived(device, heartRate, contactDetected, energyExpanded, rrIntervals);
            if (WearManager.this.mHeartRateMeasurementCallback != null) {
                WearManager.this.mHeartRateMeasurementCallback.onHeartRateMeasurementReceived(device, heartRate, contactDetected, energyExpanded, rrIntervals);
            }
        }

        @Override
        public void onDataReceived(@NonNull BluetoothDevice device, @NonNull Data data) {
            WearManager.this.log(3, HeartRateMeasurementParser.parse(data) + " received");
            super.onDataReceived(device, data);
        }
    };
    private final WearReceivedDataCallback mReceivedDataCallback = new WearReceivedDataCallback(){

        @Override
        public void onSportReceived(@NonNull BluetoothDevice device, int step, int distance, int calorie) {
            ((WearManagerCallbacks)WearManager.this.mCallbacks).onSportReceived(device, step, distance, calorie);
            if (WearManager.this.mBodySportCallback != null) {
                WearManager.this.mBodySportCallback.onSportReceived(device, step, distance, calorie);
            }
        }

        @Override
        public void onBluetoothStatusReceived(@NonNull BluetoothDevice device, boolean enabled) {
            ((WearManagerCallbacks)WearManager.this.mCallbacks).onBluetoothStatusReceived(device, enabled);
            if (WearManager.this.mBluetoothStatusCallback != null) {
                WearManager.this.mBluetoothStatusCallback.onBluetoothStatusReceived(device, enabled);
            }
        }

        @Override
        public void onUserInfoReceived(@NonNull BluetoothDevice device, int age, int sex, int weight, int height, long userId) {
            if (WearManager.this.mUserInfoCallback != null) {
                WearManager.this.mUserInfoCallback.onUserInfoReceived(device, age, sex, weight, height, userId);
            }
        }

        @Override
        public void onHistoryOfSportReceived(@NonNull BluetoothDevice device, List<HistoryOfSport> sports) {
            if (WearManager.this.mHistoryOfSportCallback != null) {
                WearManager.this.mHistoryOfSportCallback.onHistoryOfSportReceived(device, sports);
            }
        }

        @Override
        public void onHistoryOfHRRecordReceived(@NonNull BluetoothDevice device, List<HistoryOfRecord> records) {
            if (WearManager.this.mHistoryOfHRRecordCallback != null) {
                WearManager.this.mHistoryOfHRRecordCallback.onHistoryOfHRRecordReceived(device, records);
            }
        }

        @Override
        public void onHistoryOfHRDataReceived(@NonNull BluetoothDevice device, List<HistoryOfHeartRate> heartRates) {
            if (WearManager.this.mHistoryOfHRDataCallback != null) {
                WearManager.this.mHistoryOfHRDataCallback.onHistoryOfHRDataReceived(device, heartRates);
            }
        }

        @Override
        public void onHistoryOfRRRecordReceived(@NonNull BluetoothDevice device, List<HistoryOfRecord> records) {
            if (WearManager.this.mHistoryOfRRRecordCallback != null) {
                WearManager.this.mHistoryOfRRRecordCallback.onHistoryOfRRRecordReceived(device, records);
            }
        }

        @Override
        public void onHistoryOfRRDataReceived(@NonNull BluetoothDevice device, List<HistoryOfRespiratoryRate> respiratoryRates) {
            if (WearManager.this.mHistoryOfRRDataCallback != null) {
                WearManager.this.mHistoryOfRRDataCallback.onHistoryOfRRDataReceived(device, respiratoryRates);
            }
        }

        @Override
        public void onIntervalStepReceived(@NonNull BluetoothDevice device, List<IntervalStep> steps) {
            if (WearManager.this.mIntervalStepsCallback != null) {
                WearManager.this.mIntervalStepsCallback.onIntervalStepReceived(device, steps);
            }
        }

        @Override
        public void onSingleTapRecordReceived(@NonNull BluetoothDevice device, List<HistoryOfRecord> records) {
            if (WearManager.this.mSingleTapRecordCallback != null) {
                WearManager.this.mSingleTapRecordCallback.onSingleTapRecordReceived(device, records);
            }
        }

        @Override
        public void onHeartRateStatusReceived(@NonNull BluetoothDevice device, int min, int max, int goal) {
            if (WearManager.this.mHeartRateStatusCallback != null) {
                WearManager.this.mHeartRateStatusCallback.onHeartRateStatusReceived(device, min, max, goal);
            }
        }

        @Override
        public void onBloodOxygenReceived(@NonNull BluetoothDevice device, int bSwitch, String value, int gesture, int piValue, int onwrist) {
            if (WearManager.this.mBloodOxygenCallback != null) {
                WearManager.this.mBloodOxygenCallback.onBloodOxygenReceived(device, bSwitch, value, gesture, piValue, onwrist);
            }
        }

        @Override
        public void onTemperatureReceived(@NonNull BluetoothDevice device, float environment, float wrist, float body) {
            if (WearManager.this.mTemperatureCallback != null) {
                WearManager.this.mTemperatureCallback.onTemperatureReceived(device, environment, wrist, body);
            }
        }
    };

    public static synchronized WearManager getInstance(Context context) {
        if (managerInstance == null) {
            managerInstance = new WearManager(context);
        }
        return managerInstance;
    }

    private WearManager(Context context) {
        super(context);
    }

    @Override
    public void checkModel(String modelName, boolean isCL833) {
        boolean cl833 = this.checkMode(modelName);
        this.mReceivedDataCallback.setCL833(cl833 && isCL833);
        this.log(6, String.format("checkModel modelName:%s isCL833:%s", modelName, isCL833));
    }

    private boolean checkMode(String name) {
        for (String device : MODE_NAMES) {
            if (!device.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NonNull
    protected BleManager.BleManagerGattCallback getGattCallback() {
        return new WearManagerGattCallback();
    }

    public void addBodySportCallback(BodySportCallback callback) {
        this.mBodySportCallback = callback;
    }

    public void addHeartRateMeasurementCallback(HeartRateMeasurementCallback callback) {
        this.mHeartRateMeasurementCallback = callback;
    }

    public void setBluetoothStatusCallback(BluetoothStatusCallback callback) {
        this.mBluetoothStatusCallback = callback;
    }

    public void addUserInfoCallback(UserInfoCallback callback) {
        this.mUserInfoCallback = callback;
    }

    public void addHistoryOfSportCallback(HistoryOfSportCallback callback) {
        this.mHistoryOfSportCallback = callback;
    }

    public void addHistoryOfHRRecordCallback(HistoryOfHRRecordCallback callback) {
        this.mHistoryOfHRRecordCallback = callback;
    }

    public void addHistoryOfHRDataCallback(HistoryOfHRDataCallback callback) {
        this.mHistoryOfHRDataCallback = callback;
    }

    public void addHistoryOfRRRecordCallback(HistoryOfRRRecordCallback callback) {
        this.mHistoryOfRRRecordCallback = callback;
    }

    public void addHistoryOfRRDataCallback(HistoryOfRRDataCallback callback) {
        this.mHistoryOfRRDataCallback = callback;
    }

    public void addIntervalStepCallback(IntervalStepCallback callback) {
        this.mIntervalStepsCallback = callback;
    }

    public void addSingleTapRecordCallback(SingleTapRecordCallback callback) {
        this.mSingleTapRecordCallback = callback;
    }

    public void addHeartRateStatusCallback(HeartRateStatusCallback callback) {
        this.mHeartRateStatusCallback = callback;
    }

    public void addBloodOxygenCallback(BloodOxygenCallback callback) {
        this.mBloodOxygenCallback = callback;
    }

    public void addTemperatureCallback(TemperatureCallback callback) {
        this.mTemperatureCallback = callback;
    }

    public void addPPGDataCallback(PPGDataCallback callback) {
        this.mPPGDataCallback = callback;
    }

    public void setFilterNames(String ... filterNames) {
        this.mFilterNames = filterNames;
    }

    public void startScan(FilterScanCallback callback) {
        this.mScanCallback = new WearScanCallback(callback);
        BluetoothLeScannerCompat scanner = BluetoothLeScannerCompat.getScanner();
        ScanSettings settings = new ScanSettings.Builder().setLegacy(false).setReportDelay(1000L).setUseHardwareBatchingIfSupported(false).setScanMode(2).build();
        ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
        ParcelUuid uuid = new ParcelUuid(HR_SERVICE_UUID);
        filters.add(new ScanFilter.Builder().setServiceUuid(uuid).build());
        scanner.startScan(filters, settings, this.mScanCallback);
    }

    public void stopScan() {
        if (this.mScanCallback != null) {
            BluetoothLeScannerCompat scanner = BluetoothLeScannerCompat.getScanner();
            scanner.stopScan(this.mScanCallback);
        }
    }

    @Override
    public void connect(BluetoothDevice device, boolean autoConnect) {
        this.connect(device).useAutoConnect(autoConnect).enqueue();
    }

    private void sendCommand(byte cmd, int ... values) {
        byte[] result;
        int unique = 4;
        if (values != null) {
            int len = values.length + 4;
            byte[] header = HexUtil.compose(255, len, cmd);
            byte[] bytes = HexUtil.compose(values);
            result = HexUtil.append(header, bytes);
        } else {
            result = HexUtil.compose(255, 4, cmd);
        }
        byte check = this.checkSum(result);
        byte[] command = HexUtil.append(result, check);
        this.writeTxCharacteristic(command);
    }

    public void setUTCTime() {
        this.setUTCTime(DateUtil.getZoneUTC());
    }

    public void setUTCTime(long stamp) {
        this.sendCommand((byte)8, this.transformUTC(stamp));
    }

    public void shutdown() {
        this.sendCommand((byte)-15, 0);
    }

    public void restoration() {
        this.sendCommand((byte)-13, 0);
    }

    public void setBluetoothDisabled() {
        this.sendCommand((byte)63, 2);
    }

    public void getHistoryOfSport() {
        this.mReceivedDataCallback.clearType(2);
        this.sendCommand((byte)22, 0);
    }

    public void getHistoryOfHRRecord() {
        this.mReceivedDataCallback.clearType(4);
        this.sendCommand((byte)33, 0);
    }

    public void getHistoryOfHRData(long stamp) {
        this.mReceivedDataCallback.setRecordTag(stamp);
        this.mReceivedDataCallback.clearType(6);
        this.sendCommand((byte)34, HexUtil.append(1, this.transformUTC(stamp)));
    }

    public void getHistoryOfRRRecord() {
        this.mReceivedDataCallback.clearType(8);
        this.sendCommand((byte)36, new int[0]);
    }

    public void getHistoryOfRRData(long stamp) {
        this.mReceivedDataCallback.clearType(16);
        this.sendCommand((byte)37, HexUtil.append(1, this.transformUTC(stamp)));
    }

    public void getIntervalSteps() {
        this.mReceivedDataCallback.clearType(18);
        this.sendCommand((byte)64, 0);
    }

    public void getSingleTapRecords() {
        this.mReceivedDataCallback.clearType(20);
        this.sendCommand((byte)66, 0);
    }

    public void getUserInfo() {
        this.sendCommand((byte)3, 0);
    }

    public void setUserInfo(int age, int sex, int weight, int height, long userId) {
        int[] command = new int[]{(byte)age, (byte)sex, (byte)weight, (byte)height, (byte)(userId >> 32 & 0xFFL), (byte)(userId >> 24 & 0xFFL), (byte)(userId >> 16 & 0xFFL), (byte)(userId >> 8 & 0xFFL), (byte)(userId & 0xFFL)};
        this.sendCommand((byte)4, command);
    }

    public void getHeartRateStatus() {
        this.sendCommand((byte)70, 0);
    }

    public void setHeartRateStatus(int min, int max, int goal) {
        this.sendCommand((byte)70, 1, (byte)min, (byte)max, (byte)goal);
    }

    public void setBloodOxygen(int mode) {
        int[] command = new int[2];
        command[0] = (byte)mode;
        this.sendCommand((byte)55, command);
    }

    public void setCustomDataReceivedCallback(CustomDataReceivedCallback customDataReceivedCallback) {
        this.mCustomDataReceivedCallback = customDataReceivedCallback;
    }

    private final class WearManagerGattCallback
    extends FitnessManager.FitnessManagerGattCallback {
        private WearManagerGattCallback() {
            super(WearManager.this);
        }

        @Override
        protected void initialize() {
            super.initialize();
            WearManager.this.readCharacteristic(WearManager.this.mBodySensorLocationCharacteristic).with(WearManager.this.mBodySensorLocationDataCallback).fail((device, status) -> WearManager.this.log(5, "Body Sensor Location characteristic not found")).enqueue();
            WearManager.this.setNotificationCallback(WearManager.this.mHeartRateCharacteristic).with(WearManager.this.mHeartRateMeasureDataCallback);
            WearManager.this.enableNotifications(WearManager.this.mHeartRateCharacteristic).enqueue();
            WearManager.this.setNotificationCallback(WearManager.this.mRXCharacteristic).with(WearManager.this.mReceivedDataCallback);
            WearManager.this.enableNotifications(WearManager.this.mRXCharacteristic).done(device -> WearManager.this.log(3, "Rx notifications enabled")).fail((device, status) -> WearManager.this.log(5, "Rx characteristic not found")).enqueue();
            if (WearManager.this.mCustomRxCharacteristic != null) {
                WearManager.this.setNotificationCallback(WearManager.this.mCustomRxCharacteristic).with((device, data) -> {
                    byte[] value = data.getValue();
                    if (value != null && value.length > 4) {
                        int ppg = ((value[3] & 0xFF) << 8) + (value[2] & 0xFF);
                        if (WearManager.this.mPPGDataCallback != null) {
                            WearManager.this.mPPGDataCallback.onPPGDataReceived(device, ppg);
                        }
                    }
                    if (WearManager.this.mCustomDataReceivedCallback != null) {
                        WearManager.this.mCustomDataReceivedCallback.onDataReceived(device, value);
                    }
                });
                WearManager.this.enableNotifications(WearManager.this.mCustomRxCharacteristic).enqueue();
            }
        }

        @Override
        public boolean isRequiredServiceSupported(@NonNull BluetoothGatt gatt) {
            super.isRequiredServiceSupported(gatt);
            BluetoothGattService hrService = gatt.getService(HR_SERVICE_UUID);
            if (hrService != null) {
                WearManager.this.mHeartRateCharacteristic = hrService.getCharacteristic(HEART_RATE_MEASUREMENT_CHARACTERISTIC_UUID);
            }
            return WearManager.this.mHeartRateCharacteristic != null;
        }

        @Override
        protected boolean isOptionalServiceSupported(@NonNull BluetoothGatt gatt) {
            super.isOptionalServiceSupported(gatt);
            BluetoothGattService service = gatt.getService(HR_SERVICE_UUID);
            if (service != null) {
                WearManager.this.mBodySensorLocationCharacteristic = service.getCharacteristic(BODY_SENSOR_LOCATION_CHARACTERISTIC_UUID);
            }
            return WearManager.this.mBodySensorLocationCharacteristic != null;
        }

        @Override
        protected void onDeviceReady() {
            super.onDeviceReady();
            WearManager.this.setUTCTime();
        }

        @Override
        protected void onDeviceDisconnected() {
            super.onDeviceDisconnected();
            WearManager.this.mBodySensorLocationCharacteristic = null;
            WearManager.this.mHeartRateCharacteristic = null;
            WearManager.this.mReceivedDataCallback.setCL833(false);
        }
    }

    private final class WearScanCallback
    extends ScanCallback {
        private final FilterScanCallback mCallback;

        private WearScanCallback(FilterScanCallback callback) {
            this.mCallback = callback;
        }

        private boolean matchDeviceName(BluetoothDevice device) {
            if (WearManager.this.mFilterNames != null) {
                if (device != null) {
                    String name = device.getName();
                    if (device.getName() != null && !TextUtils.isEmpty((CharSequence)device.getName())) {
                        for (String filterName : WearManager.this.mFilterNames) {
                            if (!name.contains(filterName)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
            return true;
        }

        @Override
        public void onScanResult(int callbackType, @NonNull ScanResult result) {
            super.onScanResult(callbackType, result);
            if (this.mCallback != null) {
                this.mCallback.onScanResult(callbackType, result);
            }
        }

        @Override
        public void onBatchScanResults(@NonNull List<ScanResult> results) {
            ArrayList<ScanResult> scanDevices = new ArrayList<ScanResult>();
            for (ScanResult result : results) {
                BluetoothDevice device = result.getDevice();
                if (!this.matchDeviceName(device)) continue;
                scanDevices.add(result);
            }
            if (this.mCallback != null) {
                this.mCallback.onBatchScanResults(results);
                this.mCallback.onFilterScanResults(scanDevices);
            }
        }

        @Override
        public void onScanFailed(int errorCode) {
            super.onScanFailed(errorCode);
            if (this.mCallback != null) {
                this.mCallback.onScanFailed(errorCode);
            }
        }
    }
}

